//autogenerated:yes
//nolint:revive,govet,errcheck
package ardupilotmega

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestEnum_GOPRO_HEARTBEAT_STATUS(t *testing.T) {
	t.Run("zero", func(t *testing.T) {
		var e GOPRO_HEARTBEAT_STATUS
		e.UnmarshalText([]byte{})
		e.MarshalText()
		e.String()
	})

	t.Run("first entry", func(t *testing.T) {
		enc, err := GOPRO_HEARTBEAT_STATUS_DISCONNECTED.MarshalText()
		require.NoError(t, err)

		var dec GOPRO_HEARTBEAT_STATUS
		err = dec.UnmarshalText(enc)
		require.NoError(t, err)

		require.Equal(t, GOPRO_HEARTBEAT_STATUS_DISCONNECTED, dec)
	})
}
