package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/sdktime"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type VulnerabilityPatch struct {

	// 补丁编号。
	PatchId string `json:"patch_id"`

	// 补丁名称。
	PatchName *string `json:"patch_name,omitempty"`

	// 补丁类型（0：linux，1：windows，2：web-cms）。
	Type *string `json:"type,omitempty"`

	// 重要等级。
	MajorLevel *string `json:"major_level,omitempty"`

	// 补丁状态。
	Status *string `json:"status,omitempty"`

	// 修复命令。
	RepairCmd *string `json:"repair_cmd,omitempty"`

	// 修复必要程度（1：需立刻修复，2：可延后修复，3：暂可以不修复）。
	RepairNecessity *string `json:"repair_necessity,omitempty"`

	// 发布时间，格式ISO8601：YYYY-MM-DDTHH:mm:ss.ms+timezone。时区信息       为事件发生时区，无法解析时区的时间，默认时区填东八区。
	ReleaseTime *sdktime.SdkTime `json:"release_time,omitempty"`

	// 参考链接。
	ReferenceUrl *string `json:"reference_url,omitempty"`

	// 漏洞报告提供者信息。
	VendorName *string `json:"vendor_name,omitempty"`

	// 受影响软件版本。
	VulnerablePackage *string `json:"vulnerable_package,omitempty"`

	// CVE编号列表。
	CveIds *string `json:"cve_ids,omitempty"`
}

func (o VulnerabilityPatch) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityPatch struct{}"
	}

	return strings.Join([]string{"VulnerabilityPatch", string(data)}, " ")
}
