/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.api.plugin.pass;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.api.plugin.pass.NamedPass;
import org.jetbrains.java.decompiler.api.plugin.pass.Pass;
import org.jetbrains.java.decompiler.api.plugin.pass.PassContext;

public final class MainPassBuilder {
    private final List<Pass> passes = new ArrayList<Pass>();

    public MainPassBuilder addPass(String name, Pass pass) {
        this.passes.add(new NamedPass(name, pass));
        return this;
    }

    public MainPassBuilder addPass(NamedPass pass) {
        this.passes.add(pass);
        return this;
    }

    public Pass build() {
        return new CompiledPass(this.passes);
    }

    private static final class CompiledPass
    implements Pass {
        private final List<Pass> passes;

        public CompiledPass(List<Pass> passes) {
            this.passes = new ArrayList<Pass>(passes);
        }

        @Override
        public boolean run(PassContext ctx) {
            boolean res = false;
            for (Pass pass : this.passes) {
                res |= pass.run(ctx);
            }
            return res;
        }
    }
}

