// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1/model_garden_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// View enumeration of PublisherModel.
type PublisherModelView int32

const (
	// The default / unset value. The API will default to the BASIC view.
	PublisherModelView_PUBLISHER_MODEL_VIEW_UNSPECIFIED PublisherModelView = 0
	// Include basic metadata about the publisher model, but not the full
	// contents.
	PublisherModelView_PUBLISHER_MODEL_VIEW_BASIC PublisherModelView = 1
	// Include everything.
	PublisherModelView_PUBLISHER_MODEL_VIEW_FULL PublisherModelView = 2
	// Include: VersionId, ModelVersionExternalName, and SupportedActions.
	PublisherModelView_PUBLISHER_MODEL_VERSION_VIEW_BASIC PublisherModelView = 3
)

// Enum value maps for PublisherModelView.
var (
	PublisherModelView_name = map[int32]string{
		0: "PUBLISHER_MODEL_VIEW_UNSPECIFIED",
		1: "PUBLISHER_MODEL_VIEW_BASIC",
		2: "PUBLISHER_MODEL_VIEW_FULL",
		3: "PUBLISHER_MODEL_VERSION_VIEW_BASIC",
	}
	PublisherModelView_value = map[string]int32{
		"PUBLISHER_MODEL_VIEW_UNSPECIFIED":   0,
		"PUBLISHER_MODEL_VIEW_BASIC":         1,
		"PUBLISHER_MODEL_VIEW_FULL":          2,
		"PUBLISHER_MODEL_VERSION_VIEW_BASIC": 3,
	}
)

func (x PublisherModelView) Enum() *PublisherModelView {
	p := new(PublisherModelView)
	*p = x
	return p
}

func (x PublisherModelView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublisherModelView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_enumTypes[0].Descriptor()
}

func (PublisherModelView) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_model_garden_service_proto_enumTypes[0]
}

func (x PublisherModelView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublisherModelView.Descriptor instead.
func (PublisherModelView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{0}
}

// Request message for
// [ModelGardenService.GetPublisherModel][google.cloud.aiplatform.v1.ModelGardenService.GetPublisherModel]
type GetPublisherModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The IETF BCP-47 language code representing the language in which
	// the publisher model's text information should be written in.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. PublisherModel view specifying which fields to read.
	View PublisherModelView `protobuf:"varint,3,opt,name=view,proto3,enum=google.cloud.aiplatform.v1.PublisherModelView" json:"view,omitempty"`
	// Optional. Boolean indicates whether the requested model is a Hugging Face
	// model.
	IsHuggingFaceModel bool `protobuf:"varint,5,opt,name=is_hugging_face_model,json=isHuggingFaceModel,proto3" json:"is_hugging_face_model,omitempty"`
	// Optional. Token used to access Hugging Face gated models.
	HuggingFaceToken string `protobuf:"bytes,6,opt,name=hugging_face_token,json=huggingFaceToken,proto3" json:"hugging_face_token,omitempty"`
}

func (x *GetPublisherModelRequest) Reset() {
	*x = GetPublisherModelRequest{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPublisherModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPublisherModelRequest) ProtoMessage() {}

func (x *GetPublisherModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPublisherModelRequest.ProtoReflect.Descriptor instead.
func (*GetPublisherModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetPublisherModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPublisherModelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetPublisherModelRequest) GetView() PublisherModelView {
	if x != nil {
		return x.View
	}
	return PublisherModelView_PUBLISHER_MODEL_VIEW_UNSPECIFIED
}

func (x *GetPublisherModelRequest) GetIsHuggingFaceModel() bool {
	if x != nil {
		return x.IsHuggingFaceModel
	}
	return false
}

func (x *GetPublisherModelRequest) GetHuggingFaceToken() string {
	if x != nil {
		return x.HuggingFaceToken
	}
	return ""
}

// Request message for
// [ModelGardenService.Deploy][google.cloud.aiplatform.v1.ModelGardenService.Deploy].
type DeployRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The artifacts to deploy.
	//
	// Types that are assignable to Artifacts:
	//
	//	*DeployRequest_PublisherModelName
	//	*DeployRequest_HuggingFaceModelId
	Artifacts isDeployRequest_Artifacts `protobuf_oneof:"artifacts"`
	// Required. The resource name of the Location to deploy the model in.
	// Format: `projects/{project}/locations/{location}`
	Destination string `protobuf:"bytes,4,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. The model config to use for the deployment.
	// If not specified, the default model config will be used.
	ModelConfig *DeployRequest_ModelConfig `protobuf:"bytes,5,opt,name=model_config,json=modelConfig,proto3" json:"model_config,omitempty"`
	// Optional. The endpoint config to use for the deployment.
	// If not specified, the default endpoint config will be used.
	EndpointConfig *DeployRequest_EndpointConfig `protobuf:"bytes,6,opt,name=endpoint_config,json=endpointConfig,proto3" json:"endpoint_config,omitempty"`
	// Optional. The deploy config to use for the deployment.
	// If not specified, the default deploy config will be used.
	DeployConfig *DeployRequest_DeployConfig `protobuf:"bytes,7,opt,name=deploy_config,json=deployConfig,proto3" json:"deploy_config,omitempty"`
}

func (x *DeployRequest) Reset() {
	*x = DeployRequest{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest) ProtoMessage() {}

func (x *DeployRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest.ProtoReflect.Descriptor instead.
func (*DeployRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{1}
}

func (m *DeployRequest) GetArtifacts() isDeployRequest_Artifacts {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (x *DeployRequest) GetPublisherModelName() string {
	if x, ok := x.GetArtifacts().(*DeployRequest_PublisherModelName); ok {
		return x.PublisherModelName
	}
	return ""
}

func (x *DeployRequest) GetHuggingFaceModelId() string {
	if x, ok := x.GetArtifacts().(*DeployRequest_HuggingFaceModelId); ok {
		return x.HuggingFaceModelId
	}
	return ""
}

func (x *DeployRequest) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DeployRequest) GetModelConfig() *DeployRequest_ModelConfig {
	if x != nil {
		return x.ModelConfig
	}
	return nil
}

func (x *DeployRequest) GetEndpointConfig() *DeployRequest_EndpointConfig {
	if x != nil {
		return x.EndpointConfig
	}
	return nil
}

func (x *DeployRequest) GetDeployConfig() *DeployRequest_DeployConfig {
	if x != nil {
		return x.DeployConfig
	}
	return nil
}

type isDeployRequest_Artifacts interface {
	isDeployRequest_Artifacts()
}

type DeployRequest_PublisherModelName struct {
	// The Model Garden model to deploy.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
	PublisherModelName string `protobuf:"bytes,1,opt,name=publisher_model_name,json=publisherModelName,proto3,oneof"`
}

type DeployRequest_HuggingFaceModelId struct {
	// The Hugging Face model to deploy.
	// Format: Hugging Face model ID like `google/gemma-2-2b-it`.
	HuggingFaceModelId string `protobuf:"bytes,2,opt,name=hugging_face_model_id,json=huggingFaceModelId,proto3,oneof"`
}

func (*DeployRequest_PublisherModelName) isDeployRequest_Artifacts() {}

func (*DeployRequest_HuggingFaceModelId) isDeployRequest_Artifacts() {}

// Response message for
// [ModelGardenService.Deploy][google.cloud.aiplatform.v1.ModelGardenService.Deploy].
type DeployResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`
	PublisherModel string `protobuf:"bytes,1,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// Output only. The name of the Endpoint created.
	// Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The name of the Model created.
	// Format: `projects/{project}/locations/{location}/models/{model}`
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *DeployResponse) Reset() {
	*x = DeployResponse{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployResponse) ProtoMessage() {}

func (x *DeployResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployResponse.ProtoReflect.Descriptor instead.
func (*DeployResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{2}
}

func (x *DeployResponse) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *DeployResponse) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *DeployResponse) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Runtime operation information for
// [ModelGardenService.Deploy][google.cloud.aiplatform.v1.ModelGardenService.Deploy].
type DeployOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// Output only. The name of the model resource.
	PublisherModel string `protobuf:"bytes,2,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// Output only. The resource name of the Location to deploy the model in.
	// Format: `projects/{project}/locations/{location}`
	Destination string `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	// Output only. The project number where the deploy model request is sent.
	ProjectNumber int64 `protobuf:"varint,4,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// Output only. The model id to be used at query time.
	ModelId string `protobuf:"bytes,5,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
}

func (x *DeployOperationMetadata) Reset() {
	*x = DeployOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployOperationMetadata) ProtoMessage() {}

func (x *DeployOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeployOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeployOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *DeployOperationMetadata) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *DeployOperationMetadata) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DeployOperationMetadata) GetProjectNumber() int64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *DeployOperationMetadata) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

// The model config to use for the deployment.
type DeployRequest_ModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether the user accepts the End User License Agreement (EULA)
	// for the model.
	AcceptEula bool `protobuf:"varint,1,opt,name=accept_eula,json=acceptEula,proto3" json:"accept_eula,omitempty"`
	// Optional. The Hugging Face read access token used to access the model
	// artifacts of gated models.
	HuggingFaceAccessToken string `protobuf:"bytes,2,opt,name=hugging_face_access_token,json=huggingFaceAccessToken,proto3" json:"hugging_face_access_token,omitempty"`
	// Optional. If true, the model will deploy with a cached version instead of
	// directly downloading the model artifacts from Hugging Face. This is
	// suitable for VPC-SC users with limited internet access.
	HuggingFaceCacheEnabled bool `protobuf:"varint,3,opt,name=hugging_face_cache_enabled,json=huggingFaceCacheEnabled,proto3" json:"hugging_face_cache_enabled,omitempty"`
	// Optional. The user-specified display name of the uploaded model. If not
	// set, a default name will be used.
	ModelDisplayName string `protobuf:"bytes,4,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
	// Optional. The specification of the container that is to be used when
	// deploying. If not set, the default container spec will be used.
	ContainerSpec *ModelContainerSpec `protobuf:"bytes,5,opt,name=container_spec,json=containerSpec,proto3" json:"container_spec,omitempty"`
	// Optional. The ID to use for the uploaded Model, which will become the
	// final component of the model resource name. When not provided, Vertex AI
	// will generate a value for this ID. When Model Registry model is provided,
	// this field will be ignored.
	//
	// This value may be up to 63 characters, and valid characters are
	// `[a-z0-9_-]`. The first character cannot be a number or hyphen.
	ModelUserId string `protobuf:"bytes,6,opt,name=model_user_id,json=modelUserId,proto3" json:"model_user_id,omitempty"`
}

func (x *DeployRequest_ModelConfig) Reset() {
	*x = DeployRequest_ModelConfig{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_ModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_ModelConfig) ProtoMessage() {}

func (x *DeployRequest_ModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_ModelConfig.ProtoReflect.Descriptor instead.
func (*DeployRequest_ModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DeployRequest_ModelConfig) GetAcceptEula() bool {
	if x != nil {
		return x.AcceptEula
	}
	return false
}

func (x *DeployRequest_ModelConfig) GetHuggingFaceAccessToken() string {
	if x != nil {
		return x.HuggingFaceAccessToken
	}
	return ""
}

func (x *DeployRequest_ModelConfig) GetHuggingFaceCacheEnabled() bool {
	if x != nil {
		return x.HuggingFaceCacheEnabled
	}
	return false
}

func (x *DeployRequest_ModelConfig) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

func (x *DeployRequest_ModelConfig) GetContainerSpec() *ModelContainerSpec {
	if x != nil {
		return x.ContainerSpec
	}
	return nil
}

func (x *DeployRequest_ModelConfig) GetModelUserId() string {
	if x != nil {
		return x.ModelUserId
	}
	return ""
}

// The endpoint config to use for the deployment.
type DeployRequest_EndpointConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The user-specified display name of the endpoint. If not set, a
	// default name will be used.
	EndpointDisplayName string `protobuf:"bytes,1,opt,name=endpoint_display_name,json=endpointDisplayName,proto3" json:"endpoint_display_name,omitempty"`
	// Optional. Deprecated. Use dedicated_endpoint_disabled instead.
	// If true, the endpoint will be exposed through a
	// dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to the
	// dedicated DNS will be isolated from other users' traffic and will have
	// better performance and reliability. Note: Once you enabled dedicated
	// endpoint, you won't be able to send request to the shared DNS
	// {region}-aiplatform.googleapis.com. The limitations will be removed soon.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/model_garden_service.proto.
	DedicatedEndpointEnabled bool `protobuf:"varint,2,opt,name=dedicated_endpoint_enabled,json=dedicatedEndpointEnabled,proto3" json:"dedicated_endpoint_enabled,omitempty"`
	// Optional. By default, if dedicated endpoint is enabled, the endpoint will
	// be exposed through a dedicated DNS [Endpoint.dedicated_endpoint_dns].
	// Your request to the dedicated DNS will be isolated from other users'
	// traffic and will have better performance and reliability. Note: Once you
	// enabled dedicated endpoint, you won't be able to send request to the
	// shared DNS {region}-aiplatform.googleapis.com. The limitations will be
	// removed soon.
	//
	// If this field is set to true, the dedicated endpoint will be disabled
	// and the deployed model will be exposed through the shared DNS
	// {region}-aiplatform.googleapis.com.
	DedicatedEndpointDisabled bool `protobuf:"varint,4,opt,name=dedicated_endpoint_disabled,json=dedicatedEndpointDisabled,proto3" json:"dedicated_endpoint_disabled,omitempty"`
	// Optional. Immutable. The ID to use for endpoint, which will become the
	// final component of the endpoint resource name. If not provided, Vertex AI
	// will generate a value for this ID.
	//
	// If the first character is a letter, this value may be up to 63
	// characters, and valid characters are `[a-z0-9-]`. The last character must
	// be a letter or number.
	//
	// If the first character is a number, this value may be up to 9 characters,
	// and valid characters are `[0-9]` with no leading zeros.
	//
	// When using HTTP/JSON, this field is populated
	// based on a query string argument, such as `?endpoint_id=12345`. This is
	// the fallback for fields that are not included in either the URI or the
	// body.
	EndpointUserId string `protobuf:"bytes,3,opt,name=endpoint_user_id,json=endpointUserId,proto3" json:"endpoint_user_id,omitempty"`
}

func (x *DeployRequest_EndpointConfig) Reset() {
	*x = DeployRequest_EndpointConfig{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_EndpointConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_EndpointConfig) ProtoMessage() {}

func (x *DeployRequest_EndpointConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_EndpointConfig.ProtoReflect.Descriptor instead.
func (*DeployRequest_EndpointConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{1, 1}
}

func (x *DeployRequest_EndpointConfig) GetEndpointDisplayName() string {
	if x != nil {
		return x.EndpointDisplayName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1/model_garden_service.proto.
func (x *DeployRequest_EndpointConfig) GetDedicatedEndpointEnabled() bool {
	if x != nil {
		return x.DedicatedEndpointEnabled
	}
	return false
}

func (x *DeployRequest_EndpointConfig) GetDedicatedEndpointDisabled() bool {
	if x != nil {
		return x.DedicatedEndpointDisabled
	}
	return false
}

func (x *DeployRequest_EndpointConfig) GetEndpointUserId() string {
	if x != nil {
		return x.EndpointUserId
	}
	return ""
}

// The deploy config to use for the deployment.
type DeployRequest_DeployConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The dedicated resources to use for the endpoint. If not set,
	// the default resources will be used.
	DedicatedResources *DedicatedResources `protobuf:"bytes,1,opt,name=dedicated_resources,json=dedicatedResources,proto3" json:"dedicated_resources,omitempty"`
	// Optional. If true, enable the QMT fast tryout feature for this model if
	// possible.
	FastTryoutEnabled bool `protobuf:"varint,2,opt,name=fast_tryout_enabled,json=fastTryoutEnabled,proto3" json:"fast_tryout_enabled,omitempty"`
	// Optional. System labels for Model Garden deployments.
	// These labels are managed by Google and for tracking purposes only.
	SystemLabels map[string]string `protobuf:"bytes,3,rep,name=system_labels,json=systemLabels,proto3" json:"system_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DeployRequest_DeployConfig) Reset() {
	*x = DeployRequest_DeployConfig{}
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_DeployConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_DeployConfig) ProtoMessage() {}

func (x *DeployRequest_DeployConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_DeployConfig.ProtoReflect.Descriptor instead.
func (*DeployRequest_DeployConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP(), []int{1, 2}
}

func (x *DeployRequest_DeployConfig) GetDedicatedResources() *DedicatedResources {
	if x != nil {
		return x.DedicatedResources
	}
	return nil
}

func (x *DeployRequest_DeployConfig) GetFastTryoutEnabled() bool {
	if x != nil {
		return x.FastTryoutEnabled
	}
	return false
}

func (x *DeployRequest_DeployConfig) GetSystemLabels() map[string]string {
	if x != nil {
		return x.SystemLabels
	}
	return nil
}

var File_google_cloud_aiplatform_v1_model_garden_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x5f, 0x67, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbe, 0x02, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x47, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x36, 0x0a, 0x15, 0x69,
	0x73, 0x5f, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x12, 0x69, 0x73, 0x48, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x12, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66,
	0x61, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x83, 0x0c, 0x0a, 0x0d, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x14, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x15, 0x68,
	0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x68, 0x75,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64,
	0x12, 0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a,
	0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x66, 0x0a, 0x0f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xed, 0x02, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x5f, 0x65, 0x75, 0x6c, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x45, 0x75, 0x6c, 0x61, 0x12, 0x3e, 0x0a, 0x19,
	0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x1a,
	0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x63,
	0x68, 0x65, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61,
	0x63, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x31,
	0x0a, 0x12, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x5a, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x27, 0x0a,
	0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x1a, 0x85, 0x02, 0x0a, 0x0e, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a, 0x15, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x43, 0x0a, 0x1a, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x18, 0x64,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x43, 0x0a, 0x1b, 0x64, 0x65, 0x64, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x19, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x30, 0x0a, 0x10,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x1a, 0xde,
	0x02, 0x0a, 0x0c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x64, 0x0a, 0x13, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72,
	0x79, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x66, 0x61, 0x73, 0x74, 0x54, 0x72, 0x79,
	0x6f, 0x75, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x72, 0x0a, 0x0d, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x3f,
	0x0a, 0x11, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42,
	0x0b, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x22, 0xf2, 0x01, 0x0a,
	0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x59, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a,
	0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x22, 0xee, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x5f, 0x0a,
	0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59,
	0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x49, 0x64, 0x2a, 0xa1, 0x01, 0x0a, 0x12, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x55, 0x42,
	0x4c, 0x49, 0x53, 0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45,
	0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1e, 0x0a, 0x1a, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12,
	0x1d, 0x0a, 0x19, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x26,
	0x0a, 0x22, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42,
	0x41, 0x53, 0x49, 0x43, 0x10, 0x03, 0x32, 0xc9, 0x03, 0x0a, 0x12, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x47, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa6, 0x01,
	0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x2f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x66, 0xca, 0x41, 0x29,
	0x0a, 0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x3a,
	0x01, 0x2a, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xd5, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x17, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x47, 0x61, 0x72, 0x64,
	0x65, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescData = file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_model_garden_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_aiplatform_v1_model_garden_service_proto_goTypes = []any{
	(PublisherModelView)(0),              // 0: google.cloud.aiplatform.v1.PublisherModelView
	(*GetPublisherModelRequest)(nil),     // 1: google.cloud.aiplatform.v1.GetPublisherModelRequest
	(*DeployRequest)(nil),                // 2: google.cloud.aiplatform.v1.DeployRequest
	(*DeployResponse)(nil),               // 3: google.cloud.aiplatform.v1.DeployResponse
	(*DeployOperationMetadata)(nil),      // 4: google.cloud.aiplatform.v1.DeployOperationMetadata
	(*DeployRequest_ModelConfig)(nil),    // 5: google.cloud.aiplatform.v1.DeployRequest.ModelConfig
	(*DeployRequest_EndpointConfig)(nil), // 6: google.cloud.aiplatform.v1.DeployRequest.EndpointConfig
	(*DeployRequest_DeployConfig)(nil),   // 7: google.cloud.aiplatform.v1.DeployRequest.DeployConfig
	nil,                                  // 8: google.cloud.aiplatform.v1.DeployRequest.DeployConfig.SystemLabelsEntry
	(*GenericOperationMetadata)(nil),     // 9: google.cloud.aiplatform.v1.GenericOperationMetadata
	(*ModelContainerSpec)(nil),           // 10: google.cloud.aiplatform.v1.ModelContainerSpec
	(*DedicatedResources)(nil),           // 11: google.cloud.aiplatform.v1.DedicatedResources
	(*PublisherModel)(nil),               // 12: google.cloud.aiplatform.v1.PublisherModel
	(*longrunningpb.Operation)(nil),      // 13: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1_model_garden_service_proto_depIdxs = []int32{
	0,  // 0: google.cloud.aiplatform.v1.GetPublisherModelRequest.view:type_name -> google.cloud.aiplatform.v1.PublisherModelView
	5,  // 1: google.cloud.aiplatform.v1.DeployRequest.model_config:type_name -> google.cloud.aiplatform.v1.DeployRequest.ModelConfig
	6,  // 2: google.cloud.aiplatform.v1.DeployRequest.endpoint_config:type_name -> google.cloud.aiplatform.v1.DeployRequest.EndpointConfig
	7,  // 3: google.cloud.aiplatform.v1.DeployRequest.deploy_config:type_name -> google.cloud.aiplatform.v1.DeployRequest.DeployConfig
	9,  // 4: google.cloud.aiplatform.v1.DeployOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1.GenericOperationMetadata
	10, // 5: google.cloud.aiplatform.v1.DeployRequest.ModelConfig.container_spec:type_name -> google.cloud.aiplatform.v1.ModelContainerSpec
	11, // 6: google.cloud.aiplatform.v1.DeployRequest.DeployConfig.dedicated_resources:type_name -> google.cloud.aiplatform.v1.DedicatedResources
	8,  // 7: google.cloud.aiplatform.v1.DeployRequest.DeployConfig.system_labels:type_name -> google.cloud.aiplatform.v1.DeployRequest.DeployConfig.SystemLabelsEntry
	1,  // 8: google.cloud.aiplatform.v1.ModelGardenService.GetPublisherModel:input_type -> google.cloud.aiplatform.v1.GetPublisherModelRequest
	2,  // 9: google.cloud.aiplatform.v1.ModelGardenService.Deploy:input_type -> google.cloud.aiplatform.v1.DeployRequest
	12, // 10: google.cloud.aiplatform.v1.ModelGardenService.GetPublisherModel:output_type -> google.cloud.aiplatform.v1.PublisherModel
	13, // 11: google.cloud.aiplatform.v1.ModelGardenService.Deploy:output_type -> google.longrunning.Operation
	10, // [10:12] is the sub-list for method output_type
	8,  // [8:10] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_model_garden_service_proto_init() }
func file_google_cloud_aiplatform_v1_model_garden_service_proto_init() {
	if File_google_cloud_aiplatform_v1_model_garden_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1_model_proto_init()
	file_google_cloud_aiplatform_v1_operation_proto_init()
	file_google_cloud_aiplatform_v1_publisher_model_proto_init()
	file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes[1].OneofWrappers = []any{
		(*DeployRequest_PublisherModelName)(nil),
		(*DeployRequest_HuggingFaceModelId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_model_garden_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_model_garden_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_model_garden_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_model_garden_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_model_garden_service_proto = out.File
	file_google_cloud_aiplatform_v1_model_garden_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_model_garden_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_model_garden_service_proto_depIdxs = nil
}
