// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/security_settings.proto

package cxpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	SecuritySettingsService_CreateSecuritySettings_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/CreateSecuritySettings"
	SecuritySettingsService_GetSecuritySettings_FullMethodName    = "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/GetSecuritySettings"
	SecuritySettingsService_UpdateSecuritySettings_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/UpdateSecuritySettings"
	SecuritySettingsService_ListSecuritySettings_FullMethodName   = "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/ListSecuritySettings"
	SecuritySettingsService_DeleteSecuritySettings_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService/DeleteSecuritySettings"
)

// SecuritySettingsServiceClient is the client API for SecuritySettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SecuritySettingsServiceClient interface {
	// Create security settings in the specified location.
	CreateSecuritySettings(ctx context.Context, in *CreateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error)
	// Retrieves the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	// The returned settings may be stale by up to 1 minute.
	GetSecuritySettings(ctx context.Context, in *GetSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error)
	// Updates the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	UpdateSecuritySettings(ctx context.Context, in *UpdateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error)
	// Returns the list of all security settings in the specified location.
	ListSecuritySettings(ctx context.Context, in *ListSecuritySettingsRequest, opts ...grpc.CallOption) (*ListSecuritySettingsResponse, error)
	// Deletes the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	DeleteSecuritySettings(ctx context.Context, in *DeleteSecuritySettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type securitySettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSecuritySettingsServiceClient(cc grpc.ClientConnInterface) SecuritySettingsServiceClient {
	return &securitySettingsServiceClient{cc}
}

func (c *securitySettingsServiceClient) CreateSecuritySettings(ctx context.Context, in *CreateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error) {
	out := new(SecuritySettings)
	err := c.cc.Invoke(ctx, SecuritySettingsService_CreateSecuritySettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) GetSecuritySettings(ctx context.Context, in *GetSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error) {
	out := new(SecuritySettings)
	err := c.cc.Invoke(ctx, SecuritySettingsService_GetSecuritySettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) UpdateSecuritySettings(ctx context.Context, in *UpdateSecuritySettingsRequest, opts ...grpc.CallOption) (*SecuritySettings, error) {
	out := new(SecuritySettings)
	err := c.cc.Invoke(ctx, SecuritySettingsService_UpdateSecuritySettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) ListSecuritySettings(ctx context.Context, in *ListSecuritySettingsRequest, opts ...grpc.CallOption) (*ListSecuritySettingsResponse, error) {
	out := new(ListSecuritySettingsResponse)
	err := c.cc.Invoke(ctx, SecuritySettingsService_ListSecuritySettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securitySettingsServiceClient) DeleteSecuritySettings(ctx context.Context, in *DeleteSecuritySettingsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, SecuritySettingsService_DeleteSecuritySettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecuritySettingsServiceServer is the server API for SecuritySettingsService service.
// All implementations should embed UnimplementedSecuritySettingsServiceServer
// for forward compatibility
type SecuritySettingsServiceServer interface {
	// Create security settings in the specified location.
	CreateSecuritySettings(context.Context, *CreateSecuritySettingsRequest) (*SecuritySettings, error)
	// Retrieves the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	// The returned settings may be stale by up to 1 minute.
	GetSecuritySettings(context.Context, *GetSecuritySettingsRequest) (*SecuritySettings, error)
	// Updates the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	UpdateSecuritySettings(context.Context, *UpdateSecuritySettingsRequest) (*SecuritySettings, error)
	// Returns the list of all security settings in the specified location.
	ListSecuritySettings(context.Context, *ListSecuritySettingsRequest) (*ListSecuritySettingsResponse, error)
	// Deletes the specified
	// [SecuritySettings][google.cloud.dialogflow.cx.v3beta1.SecuritySettings].
	DeleteSecuritySettings(context.Context, *DeleteSecuritySettingsRequest) (*emptypb.Empty, error)
}

// UnimplementedSecuritySettingsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSecuritySettingsServiceServer struct {
}

func (UnimplementedSecuritySettingsServiceServer) CreateSecuritySettings(context.Context, *CreateSecuritySettingsRequest) (*SecuritySettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSecuritySettings not implemented")
}
func (UnimplementedSecuritySettingsServiceServer) GetSecuritySettings(context.Context, *GetSecuritySettingsRequest) (*SecuritySettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSecuritySettings not implemented")
}
func (UnimplementedSecuritySettingsServiceServer) UpdateSecuritySettings(context.Context, *UpdateSecuritySettingsRequest) (*SecuritySettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSecuritySettings not implemented")
}
func (UnimplementedSecuritySettingsServiceServer) ListSecuritySettings(context.Context, *ListSecuritySettingsRequest) (*ListSecuritySettingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSecuritySettings not implemented")
}
func (UnimplementedSecuritySettingsServiceServer) DeleteSecuritySettings(context.Context, *DeleteSecuritySettingsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSecuritySettings not implemented")
}

// UnsafeSecuritySettingsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SecuritySettingsServiceServer will
// result in compilation errors.
type UnsafeSecuritySettingsServiceServer interface {
	mustEmbedUnimplementedSecuritySettingsServiceServer()
}

func RegisterSecuritySettingsServiceServer(s grpc.ServiceRegistrar, srv SecuritySettingsServiceServer) {
	s.RegisterService(&SecuritySettingsService_ServiceDesc, srv)
}

func _SecuritySettingsService_CreateSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).CreateSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecuritySettingsService_CreateSecuritySettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).CreateSecuritySettings(ctx, req.(*CreateSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_GetSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).GetSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecuritySettingsService_GetSecuritySettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).GetSecuritySettings(ctx, req.(*GetSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_UpdateSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).UpdateSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecuritySettingsService_UpdateSecuritySettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).UpdateSecuritySettings(ctx, req.(*UpdateSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_ListSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).ListSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecuritySettingsService_ListSecuritySettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).ListSecuritySettings(ctx, req.(*ListSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecuritySettingsService_DeleteSecuritySettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSecuritySettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecuritySettingsServiceServer).DeleteSecuritySettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: SecuritySettingsService_DeleteSecuritySettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecuritySettingsServiceServer).DeleteSecuritySettings(ctx, req.(*DeleteSecuritySettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// SecuritySettingsService_ServiceDesc is the grpc.ServiceDesc for SecuritySettingsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SecuritySettingsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.SecuritySettingsService",
	HandlerType: (*SecuritySettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSecuritySettings",
			Handler:    _SecuritySettingsService_CreateSecuritySettings_Handler,
		},
		{
			MethodName: "GetSecuritySettings",
			Handler:    _SecuritySettingsService_GetSecuritySettings_Handler,
		},
		{
			MethodName: "UpdateSecuritySettings",
			Handler:    _SecuritySettingsService_UpdateSecuritySettings_Handler,
		},
		{
			MethodName: "ListSecuritySettings",
			Handler:    _SecuritySettingsService_ListSecuritySettings_Handler,
		},
		{
			MethodName: "DeleteSecuritySettings",
			Handler:    _SecuritySettingsService_DeleteSecuritySettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/security_settings.proto",
}
