package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListTopicAccessPolicyRequest Request Object
type ListTopicAccessPolicyRequest struct {

	// 实例ID。
	InstanceId string `json:"instance_id"`

	// 主题名称。
	Topic string `json:"topic"`

	// 偏移量，表示从此偏移量开始查询， offset大于等于0。
	Offset *string `json:"offset,omitempty"`

	// 查询数量。
	Limit *string `json:"limit,omitempty"`
}

func (o ListTopicAccessPolicyRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListTopicAccessPolicyRequest struct{}"
	}

	return strings.Join([]string{"ListTopicAccessPolicyRequest", string(data)}, " ")
}
