// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/devtools/clouderrorreporting/v1beta1/report_errors_service.proto

package errorreportingpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ReportErrorsService_ReportErrorEvent_FullMethodName = "/google.devtools.clouderrorreporting.v1beta1.ReportErrorsService/ReportErrorEvent"
)

// ReportErrorsServiceClient is the client API for ReportErrorsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReportErrorsServiceClient interface {
	// Report an individual error event and record the event to a log.
	//
	// This endpoint accepts **either** an OAuth token,
	// **or** an [API key](https://support.google.com/cloud/answer/6158862)
	// for authentication. To use an API key, append it to the URL as the value of
	// a `key` parameter. For example:
	//
	// `POST
	// https://clouderrorreporting.googleapis.com/v1beta1/{projectName}/events:report?key=123ABC456`
	//
	// **Note:** [Error Reporting] (https://cloud.google.com/error-reporting)
	// is a service built on Cloud Logging and can analyze log entries when all of
	// the following are true:
	//
	// * Customer-managed encryption keys (CMEK) are disabled on the log bucket.
	// * The log bucket satisfies one of the following:
	//   - The log bucket is stored in the same project where the logs
	//     originated.
	//   - The logs were routed to a project, and then that project stored those
	//     logs in a log bucket that it owns.
	ReportErrorEvent(ctx context.Context, in *ReportErrorEventRequest, opts ...grpc.CallOption) (*ReportErrorEventResponse, error)
}

type reportErrorsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReportErrorsServiceClient(cc grpc.ClientConnInterface) ReportErrorsServiceClient {
	return &reportErrorsServiceClient{cc}
}

func (c *reportErrorsServiceClient) ReportErrorEvent(ctx context.Context, in *ReportErrorEventRequest, opts ...grpc.CallOption) (*ReportErrorEventResponse, error) {
	out := new(ReportErrorEventResponse)
	err := c.cc.Invoke(ctx, ReportErrorsService_ReportErrorEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReportErrorsServiceServer is the server API for ReportErrorsService service.
// All implementations should embed UnimplementedReportErrorsServiceServer
// for forward compatibility
type ReportErrorsServiceServer interface {
	// Report an individual error event and record the event to a log.
	//
	// This endpoint accepts **either** an OAuth token,
	// **or** an [API key](https://support.google.com/cloud/answer/6158862)
	// for authentication. To use an API key, append it to the URL as the value of
	// a `key` parameter. For example:
	//
	// `POST
	// https://clouderrorreporting.googleapis.com/v1beta1/{projectName}/events:report?key=123ABC456`
	//
	// **Note:** [Error Reporting] (https://cloud.google.com/error-reporting)
	// is a service built on Cloud Logging and can analyze log entries when all of
	// the following are true:
	//
	// * Customer-managed encryption keys (CMEK) are disabled on the log bucket.
	// * The log bucket satisfies one of the following:
	//   - The log bucket is stored in the same project where the logs
	//     originated.
	//   - The logs were routed to a project, and then that project stored those
	//     logs in a log bucket that it owns.
	ReportErrorEvent(context.Context, *ReportErrorEventRequest) (*ReportErrorEventResponse, error)
}

// UnimplementedReportErrorsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedReportErrorsServiceServer struct {
}

func (UnimplementedReportErrorsServiceServer) ReportErrorEvent(context.Context, *ReportErrorEventRequest) (*ReportErrorEventResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportErrorEvent not implemented")
}

// UnsafeReportErrorsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReportErrorsServiceServer will
// result in compilation errors.
type UnsafeReportErrorsServiceServer interface {
	mustEmbedUnimplementedReportErrorsServiceServer()
}

func RegisterReportErrorsServiceServer(s grpc.ServiceRegistrar, srv ReportErrorsServiceServer) {
	s.RegisterService(&ReportErrorsService_ServiceDesc, srv)
}

func _ReportErrorsService_ReportErrorEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportErrorEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReportErrorsServiceServer).ReportErrorEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReportErrorsService_ReportErrorEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReportErrorsServiceServer).ReportErrorEvent(ctx, req.(*ReportErrorEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ReportErrorsService_ServiceDesc is the grpc.ServiceDesc for ReportErrorsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReportErrorsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ReportErrorsService",
	HandlerType: (*ReportErrorsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ReportErrorEvent",
			Handler:    _ReportErrorsService_ReportErrorEvent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouderrorreporting/v1beta1/report_errors_service.proto",
}
