// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/routeoptimization/v1/route_optimization_service.proto

package routeoptimizationpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	RouteOptimization_OptimizeTours_FullMethodName      = "/google.maps.routeoptimization.v1.RouteOptimization/OptimizeTours"
	RouteOptimization_BatchOptimizeTours_FullMethodName = "/google.maps.routeoptimization.v1.RouteOptimization/BatchOptimizeTours"
)

// RouteOptimizationClient is the client API for RouteOptimization service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RouteOptimizationClient interface {
	// Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
	// `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
	// routes to be performed by vehicles minimizing the overall cost.
	//
	// A `ShipmentModel` model consists mainly of `Shipment`s that need to be
	// carried out and `Vehicle`s that can be used to transport the `Shipment`s.
	// The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
	// they assign a series of `Visit`s to each vehicle, where a `Visit`
	// corresponds to a `VisitRequest`, which is a pickup or delivery for a
	// `Shipment`.
	//
	// The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
	// minimizes the total cost where cost has many components defined in the
	// `ShipmentModel`.
	OptimizeTours(ctx context.Context, in *OptimizeToursRequest, opts ...grpc.CallOption) (*OptimizeToursResponse, error)
	// Optimizes vehicle tours for one or more `OptimizeToursRequest`
	// messages as a batch.
	//
	// This method is a Long Running Operation (LRO). The inputs for optimization
	// (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
	// messages) are read from and written to Cloud Storage in user-specified
	// format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
	// contains a `ShipmentModel` and returns an `OptimizeToursResponse`
	// containing `ShipmentRoute` fields, which are a set of routes to be
	// performed by vehicles minimizing the overall cost.
	//
	// The user can poll `operations.get` to check the status of the LRO:
	//
	// If the LRO `done` field is false, then at least one request is still
	// being processed. Other requests may have completed successfully and their
	// results are available in Cloud Storage.
	//
	// If the LRO's `done` field is true, then all requests have been processed.
	// Any successfully processed requests will have their results available in
	// Cloud Storage. Any requests that failed will not have their results
	// available in Cloud Storage. If the LRO's `error` field is set, then it
	// contains the error from one of the failed requests.
	BatchOptimizeTours(ctx context.Context, in *BatchOptimizeToursRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type routeOptimizationClient struct {
	cc grpc.ClientConnInterface
}

func NewRouteOptimizationClient(cc grpc.ClientConnInterface) RouteOptimizationClient {
	return &routeOptimizationClient{cc}
}

func (c *routeOptimizationClient) OptimizeTours(ctx context.Context, in *OptimizeToursRequest, opts ...grpc.CallOption) (*OptimizeToursResponse, error) {
	out := new(OptimizeToursResponse)
	err := c.cc.Invoke(ctx, RouteOptimization_OptimizeTours_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *routeOptimizationClient) BatchOptimizeTours(ctx context.Context, in *BatchOptimizeToursRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, RouteOptimization_BatchOptimizeTours_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RouteOptimizationServer is the server API for RouteOptimization service.
// All implementations should embed UnimplementedRouteOptimizationServer
// for forward compatibility
type RouteOptimizationServer interface {
	// Sends an `OptimizeToursRequest` containing a `ShipmentModel` and returns an
	// `OptimizeToursResponse` containing `ShipmentRoute`s, which are a set of
	// routes to be performed by vehicles minimizing the overall cost.
	//
	// A `ShipmentModel` model consists mainly of `Shipment`s that need to be
	// carried out and `Vehicle`s that can be used to transport the `Shipment`s.
	// The `ShipmentRoute`s assign `Shipment`s to `Vehicle`s. More specifically,
	// they assign a series of `Visit`s to each vehicle, where a `Visit`
	// corresponds to a `VisitRequest`, which is a pickup or delivery for a
	// `Shipment`.
	//
	// The goal is to provide an assignment of `ShipmentRoute`s to `Vehicle`s that
	// minimizes the total cost where cost has many components defined in the
	// `ShipmentModel`.
	OptimizeTours(context.Context, *OptimizeToursRequest) (*OptimizeToursResponse, error)
	// Optimizes vehicle tours for one or more `OptimizeToursRequest`
	// messages as a batch.
	//
	// This method is a Long Running Operation (LRO). The inputs for optimization
	// (`OptimizeToursRequest` messages) and outputs (`OptimizeToursResponse`
	// messages) are read from and written to Cloud Storage in user-specified
	// format. Like the `OptimizeTours` method, each `OptimizeToursRequest`
	// contains a `ShipmentModel` and returns an `OptimizeToursResponse`
	// containing `ShipmentRoute` fields, which are a set of routes to be
	// performed by vehicles minimizing the overall cost.
	//
	// The user can poll `operations.get` to check the status of the LRO:
	//
	// If the LRO `done` field is false, then at least one request is still
	// being processed. Other requests may have completed successfully and their
	// results are available in Cloud Storage.
	//
	// If the LRO's `done` field is true, then all requests have been processed.
	// Any successfully processed requests will have their results available in
	// Cloud Storage. Any requests that failed will not have their results
	// available in Cloud Storage. If the LRO's `error` field is set, then it
	// contains the error from one of the failed requests.
	BatchOptimizeTours(context.Context, *BatchOptimizeToursRequest) (*longrunningpb.Operation, error)
}

// UnimplementedRouteOptimizationServer should be embedded to have forward compatible implementations.
type UnimplementedRouteOptimizationServer struct {
}

func (UnimplementedRouteOptimizationServer) OptimizeTours(context.Context, *OptimizeToursRequest) (*OptimizeToursResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OptimizeTours not implemented")
}
func (UnimplementedRouteOptimizationServer) BatchOptimizeTours(context.Context, *BatchOptimizeToursRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchOptimizeTours not implemented")
}

// UnsafeRouteOptimizationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RouteOptimizationServer will
// result in compilation errors.
type UnsafeRouteOptimizationServer interface {
	mustEmbedUnimplementedRouteOptimizationServer()
}

func RegisterRouteOptimizationServer(s grpc.ServiceRegistrar, srv RouteOptimizationServer) {
	s.RegisterService(&RouteOptimization_ServiceDesc, srv)
}

func _RouteOptimization_OptimizeTours_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OptimizeToursRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteOptimizationServer).OptimizeTours(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RouteOptimization_OptimizeTours_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteOptimizationServer).OptimizeTours(ctx, req.(*OptimizeToursRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RouteOptimization_BatchOptimizeTours_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchOptimizeToursRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RouteOptimizationServer).BatchOptimizeTours(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RouteOptimization_BatchOptimizeTours_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RouteOptimizationServer).BatchOptimizeTours(ctx, req.(*BatchOptimizeToursRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RouteOptimization_ServiceDesc is the grpc.ServiceDesc for RouteOptimization service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RouteOptimization_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.routeoptimization.v1.RouteOptimization",
	HandlerType: (*RouteOptimizationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "OptimizeTours",
			Handler:    _RouteOptimization_OptimizeTours_Handler,
		},
		{
			MethodName: "BatchOptimizeTours",
			Handler:    _RouteOptimization_BatchOptimizeTours_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/routeoptimization/v1/route_optimization_service.proto",
}
