// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/storage/v1/bucket_service.proto

package storage

import (
	context "context"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	BucketService_List_FullMethodName                         = "/yandex.cloud.storage.v1.BucketService/List"
	BucketService_Get_FullMethodName                          = "/yandex.cloud.storage.v1.BucketService/Get"
	BucketService_Create_FullMethodName                       = "/yandex.cloud.storage.v1.BucketService/Create"
	BucketService_Update_FullMethodName                       = "/yandex.cloud.storage.v1.BucketService/Update"
	BucketService_Delete_FullMethodName                       = "/yandex.cloud.storage.v1.BucketService/Delete"
	BucketService_GetStats_FullMethodName                     = "/yandex.cloud.storage.v1.BucketService/GetStats"
	BucketService_GetHTTPSConfig_FullMethodName               = "/yandex.cloud.storage.v1.BucketService/GetHTTPSConfig"
	BucketService_SetHTTPSConfig_FullMethodName               = "/yandex.cloud.storage.v1.BucketService/SetHTTPSConfig"
	BucketService_DeleteHTTPSConfig_FullMethodName            = "/yandex.cloud.storage.v1.BucketService/DeleteHTTPSConfig"
	BucketService_SetAccessBindings_FullMethodName            = "/yandex.cloud.storage.v1.BucketService/SetAccessBindings"
	BucketService_UpdateAccessBindings_FullMethodName         = "/yandex.cloud.storage.v1.BucketService/UpdateAccessBindings"
	BucketService_ListAccessBindings_FullMethodName           = "/yandex.cloud.storage.v1.BucketService/ListAccessBindings"
	BucketService_CreateInventoryConfiguration_FullMethodName = "/yandex.cloud.storage.v1.BucketService/CreateInventoryConfiguration"
	BucketService_GetInventoryConfiguration_FullMethodName    = "/yandex.cloud.storage.v1.BucketService/GetInventoryConfiguration"
	BucketService_DeleteInventoryConfiguration_FullMethodName = "/yandex.cloud.storage.v1.BucketService/DeleteInventoryConfiguration"
	BucketService_ListInventoryConfigurations_FullMethodName  = "/yandex.cloud.storage.v1.BucketService/ListInventoryConfigurations"
)

// BucketServiceClient is the client API for BucketService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing buckets.
type BucketServiceClient interface {
	// Retrieves the list of buckets in the specified folder.
	//
	// The following fields will not be returned for buckets in the list: [Bucket.policy], [Bucket.acl], [Bucket.cors],
	// [Bucket.website_settings], [Bucket.lifecycle_rules], [Bucket.tags].
	List(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error)
	// Returns the specified bucket.
	//
	// To get the list of all available buckets, make a [List] request.
	Get(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error)
	// Creates a bucket in the specified folder.
	Create(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates the specified bucket.
	//
	// In most cases, `storage.editor` role (see [documentation](/docs/storage/security/#storage-editor)) should be enough
	// to update a bucket, subject to its [policy](/docs/storage/concepts/policy).
	Update(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the specified bucket.
	Delete(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Returns the statistics for the specified bucket.
	GetStats(ctx context.Context, in *GetBucketStatsRequest, opts ...grpc.CallOption) (*BucketStats, error)
	// Returns the HTTPS configuration for the specified bucket.
	GetHTTPSConfig(ctx context.Context, in *GetBucketHTTPSConfigRequest, opts ...grpc.CallOption) (*HTTPSConfig, error)
	// Updates the HTTPS configuration for the specified bucket.
	//
	// The updated configuration could take up to 30 minutes to apply to the bucket.
	SetHTTPSConfig(ctx context.Context, in *SetBucketHTTPSConfigRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes the HTTPS configuration for the specified bucket.
	// (-- api-linter: yc::1705::http-method-mapping=disabled
	//
	//	for compatibility with old format --)
	DeleteHTTPSConfig(ctx context.Context, in *DeleteBucketHTTPSConfigRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Sets access bindings for the specified bucket.
	SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates access bindings for the specified bucket.
	// (-- api-linter: yc::1705::http-method-mapping=disabled
	//
	//	for compatibility with old format --)
	UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Lists access bindings for the specified bucket.
	ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	// Create/Update an inventory configuration with the corresponding ID
	CreateInventoryConfiguration(ctx context.Context, in *CreateBucketInventoryConfigurationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Get an inventory configuration with the corresponding ID
	GetInventoryConfiguration(ctx context.Context, in *GetBucketInventoryConfigurationRequest, opts ...grpc.CallOption) (*InventoryConfiguration, error)
	// Delete an inventory configuration with the corresponding ID
	DeleteInventoryConfiguration(ctx context.Context, in *DeleteBucketInventoryConfigurationRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Listing inventory configurations
	ListInventoryConfigurations(ctx context.Context, in *ListBucketInventoryConfigurationsRequest, opts ...grpc.CallOption) (*ListBucketInventoryConfigurationsResponse, error)
}

type bucketServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBucketServiceClient(cc grpc.ClientConnInterface) BucketServiceClient {
	return &bucketServiceClient{cc}
}

func (c *bucketServiceClient) List(ctx context.Context, in *ListBucketsRequest, opts ...grpc.CallOption) (*ListBucketsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBucketsResponse)
	err := c.cc.Invoke(ctx, BucketService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) Get(ctx context.Context, in *GetBucketRequest, opts ...grpc.CallOption) (*Bucket, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Bucket)
	err := c.cc.Invoke(ctx, BucketService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) Create(ctx context.Context, in *CreateBucketRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) Update(ctx context.Context, in *UpdateBucketRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) Delete(ctx context.Context, in *DeleteBucketRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) GetStats(ctx context.Context, in *GetBucketStatsRequest, opts ...grpc.CallOption) (*BucketStats, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BucketStats)
	err := c.cc.Invoke(ctx, BucketService_GetStats_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) GetHTTPSConfig(ctx context.Context, in *GetBucketHTTPSConfigRequest, opts ...grpc.CallOption) (*HTTPSConfig, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(HTTPSConfig)
	err := c.cc.Invoke(ctx, BucketService_GetHTTPSConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) SetHTTPSConfig(ctx context.Context, in *SetBucketHTTPSConfigRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_SetHTTPSConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) DeleteHTTPSConfig(ctx context.Context, in *DeleteBucketHTTPSConfigRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_DeleteHTTPSConfig_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_SetAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_UpdateAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(access.ListAccessBindingsResponse)
	err := c.cc.Invoke(ctx, BucketService_ListAccessBindings_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) CreateInventoryConfiguration(ctx context.Context, in *CreateBucketInventoryConfigurationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_CreateInventoryConfiguration_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) GetInventoryConfiguration(ctx context.Context, in *GetBucketInventoryConfigurationRequest, opts ...grpc.CallOption) (*InventoryConfiguration, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(InventoryConfiguration)
	err := c.cc.Invoke(ctx, BucketService_GetInventoryConfiguration_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) DeleteInventoryConfiguration(ctx context.Context, in *DeleteBucketInventoryConfigurationRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, BucketService_DeleteInventoryConfiguration_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bucketServiceClient) ListInventoryConfigurations(ctx context.Context, in *ListBucketInventoryConfigurationsRequest, opts ...grpc.CallOption) (*ListBucketInventoryConfigurationsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListBucketInventoryConfigurationsResponse)
	err := c.cc.Invoke(ctx, BucketService_ListInventoryConfigurations_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BucketServiceServer is the server API for BucketService service.
// All implementations should embed UnimplementedBucketServiceServer
// for forward compatibility.
//
// A set of methods for managing buckets.
type BucketServiceServer interface {
	// Retrieves the list of buckets in the specified folder.
	//
	// The following fields will not be returned for buckets in the list: [Bucket.policy], [Bucket.acl], [Bucket.cors],
	// [Bucket.website_settings], [Bucket.lifecycle_rules], [Bucket.tags].
	List(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error)
	// Returns the specified bucket.
	//
	// To get the list of all available buckets, make a [List] request.
	Get(context.Context, *GetBucketRequest) (*Bucket, error)
	// Creates a bucket in the specified folder.
	Create(context.Context, *CreateBucketRequest) (*operation.Operation, error)
	// Updates the specified bucket.
	//
	// In most cases, `storage.editor` role (see [documentation](/docs/storage/security/#storage-editor)) should be enough
	// to update a bucket, subject to its [policy](/docs/storage/concepts/policy).
	Update(context.Context, *UpdateBucketRequest) (*operation.Operation, error)
	// Deletes the specified bucket.
	Delete(context.Context, *DeleteBucketRequest) (*operation.Operation, error)
	// Returns the statistics for the specified bucket.
	GetStats(context.Context, *GetBucketStatsRequest) (*BucketStats, error)
	// Returns the HTTPS configuration for the specified bucket.
	GetHTTPSConfig(context.Context, *GetBucketHTTPSConfigRequest) (*HTTPSConfig, error)
	// Updates the HTTPS configuration for the specified bucket.
	//
	// The updated configuration could take up to 30 minutes to apply to the bucket.
	SetHTTPSConfig(context.Context, *SetBucketHTTPSConfigRequest) (*operation.Operation, error)
	// Deletes the HTTPS configuration for the specified bucket.
	// (-- api-linter: yc::1705::http-method-mapping=disabled
	//
	//	for compatibility with old format --)
	DeleteHTTPSConfig(context.Context, *DeleteBucketHTTPSConfigRequest) (*operation.Operation, error)
	// Sets access bindings for the specified bucket.
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error)
	// Updates access bindings for the specified bucket.
	// (-- api-linter: yc::1705::http-method-mapping=disabled
	//
	//	for compatibility with old format --)
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error)
	// Lists access bindings for the specified bucket.
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error)
	// Create/Update an inventory configuration with the corresponding ID
	CreateInventoryConfiguration(context.Context, *CreateBucketInventoryConfigurationRequest) (*operation.Operation, error)
	// Get an inventory configuration with the corresponding ID
	GetInventoryConfiguration(context.Context, *GetBucketInventoryConfigurationRequest) (*InventoryConfiguration, error)
	// Delete an inventory configuration with the corresponding ID
	DeleteInventoryConfiguration(context.Context, *DeleteBucketInventoryConfigurationRequest) (*operation.Operation, error)
	// Listing inventory configurations
	ListInventoryConfigurations(context.Context, *ListBucketInventoryConfigurationsRequest) (*ListBucketInventoryConfigurationsResponse, error)
}

// UnimplementedBucketServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedBucketServiceServer struct{}

func (UnimplementedBucketServiceServer) List(context.Context, *ListBucketsRequest) (*ListBucketsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedBucketServiceServer) Get(context.Context, *GetBucketRequest) (*Bucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedBucketServiceServer) Create(context.Context, *CreateBucketRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedBucketServiceServer) Update(context.Context, *UpdateBucketRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedBucketServiceServer) Delete(context.Context, *DeleteBucketRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedBucketServiceServer) GetStats(context.Context, *GetBucketStatsRequest) (*BucketStats, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStats not implemented")
}
func (UnimplementedBucketServiceServer) GetHTTPSConfig(context.Context, *GetBucketHTTPSConfigRequest) (*HTTPSConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHTTPSConfig not implemented")
}
func (UnimplementedBucketServiceServer) SetHTTPSConfig(context.Context, *SetBucketHTTPSConfigRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetHTTPSConfig not implemented")
}
func (UnimplementedBucketServiceServer) DeleteHTTPSConfig(context.Context, *DeleteBucketHTTPSConfigRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHTTPSConfig not implemented")
}
func (UnimplementedBucketServiceServer) SetAccessBindings(context.Context, *access.SetAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAccessBindings not implemented")
}
func (UnimplementedBucketServiceServer) UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessBindings not implemented")
}
func (UnimplementedBucketServiceServer) ListAccessBindings(context.Context, *access.ListAccessBindingsRequest) (*access.ListAccessBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccessBindings not implemented")
}
func (UnimplementedBucketServiceServer) CreateInventoryConfiguration(context.Context, *CreateBucketInventoryConfigurationRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInventoryConfiguration not implemented")
}
func (UnimplementedBucketServiceServer) GetInventoryConfiguration(context.Context, *GetBucketInventoryConfigurationRequest) (*InventoryConfiguration, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInventoryConfiguration not implemented")
}
func (UnimplementedBucketServiceServer) DeleteInventoryConfiguration(context.Context, *DeleteBucketInventoryConfigurationRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInventoryConfiguration not implemented")
}
func (UnimplementedBucketServiceServer) ListInventoryConfigurations(context.Context, *ListBucketInventoryConfigurationsRequest) (*ListBucketInventoryConfigurationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInventoryConfigurations not implemented")
}
func (UnimplementedBucketServiceServer) testEmbeddedByValue() {}

// UnsafeBucketServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BucketServiceServer will
// result in compilation errors.
type UnsafeBucketServiceServer interface {
	mustEmbedUnimplementedBucketServiceServer()
}

func RegisterBucketServiceServer(s grpc.ServiceRegistrar, srv BucketServiceServer) {
	// If the following call pancis, it indicates UnimplementedBucketServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&BucketService_ServiceDesc, srv)
}

func _BucketService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).List(ctx, req.(*ListBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).Get(ctx, req.(*GetBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).Create(ctx, req.(*CreateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).Update(ctx, req.(*UpdateBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).Delete(ctx, req.(*DeleteBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_GetStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).GetStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_GetStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).GetStats(ctx, req.(*GetBucketStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_GetHTTPSConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketHTTPSConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).GetHTTPSConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_GetHTTPSConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).GetHTTPSConfig(ctx, req.(*GetBucketHTTPSConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_SetHTTPSConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetBucketHTTPSConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).SetHTTPSConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_SetHTTPSConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).SetHTTPSConfig(ctx, req.(*SetBucketHTTPSConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_DeleteHTTPSConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketHTTPSConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).DeleteHTTPSConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_DeleteHTTPSConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).DeleteHTTPSConfig(ctx, req.(*DeleteBucketHTTPSConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_SetAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.SetAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).SetAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_SetAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).SetAccessBindings(ctx, req.(*access.SetAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_UpdateAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.UpdateAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).UpdateAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_UpdateAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).UpdateAccessBindings(ctx, req.(*access.UpdateAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_ListAccessBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(access.ListAccessBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).ListAccessBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_ListAccessBindings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).ListAccessBindings(ctx, req.(*access.ListAccessBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_CreateInventoryConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBucketInventoryConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).CreateInventoryConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_CreateInventoryConfiguration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).CreateInventoryConfiguration(ctx, req.(*CreateBucketInventoryConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_GetInventoryConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBucketInventoryConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).GetInventoryConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_GetInventoryConfiguration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).GetInventoryConfiguration(ctx, req.(*GetBucketInventoryConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_DeleteInventoryConfiguration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBucketInventoryConfigurationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).DeleteInventoryConfiguration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_DeleteInventoryConfiguration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).DeleteInventoryConfiguration(ctx, req.(*DeleteBucketInventoryConfigurationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BucketService_ListInventoryConfigurations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBucketInventoryConfigurationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BucketServiceServer).ListInventoryConfigurations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BucketService_ListInventoryConfigurations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BucketServiceServer).ListInventoryConfigurations(ctx, req.(*ListBucketInventoryConfigurationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BucketService_ServiceDesc is the grpc.ServiceDesc for BucketService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BucketService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.storage.v1.BucketService",
	HandlerType: (*BucketServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _BucketService_List_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _BucketService_Get_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _BucketService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _BucketService_Update_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _BucketService_Delete_Handler,
		},
		{
			MethodName: "GetStats",
			Handler:    _BucketService_GetStats_Handler,
		},
		{
			MethodName: "GetHTTPSConfig",
			Handler:    _BucketService_GetHTTPSConfig_Handler,
		},
		{
			MethodName: "SetHTTPSConfig",
			Handler:    _BucketService_SetHTTPSConfig_Handler,
		},
		{
			MethodName: "DeleteHTTPSConfig",
			Handler:    _BucketService_DeleteHTTPSConfig_Handler,
		},
		{
			MethodName: "SetAccessBindings",
			Handler:    _BucketService_SetAccessBindings_Handler,
		},
		{
			MethodName: "UpdateAccessBindings",
			Handler:    _BucketService_UpdateAccessBindings_Handler,
		},
		{
			MethodName: "ListAccessBindings",
			Handler:    _BucketService_ListAccessBindings_Handler,
		},
		{
			MethodName: "CreateInventoryConfiguration",
			Handler:    _BucketService_CreateInventoryConfiguration_Handler,
		},
		{
			MethodName: "GetInventoryConfiguration",
			Handler:    _BucketService_GetInventoryConfiguration_Handler,
		},
		{
			MethodName: "DeleteInventoryConfiguration",
			Handler:    _BucketService_DeleteInventoryConfiguration_Handler,
		},
		{
			MethodName: "ListInventoryConfigurations",
			Handler:    _BucketService_ListInventoryConfigurations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/storage/v1/bucket_service.proto",
}
