/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.shortcut;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.ubnt.data.X;
import com.ubnt.model.api.shortcut.FeatureShortcutDto;
import com.ubnt.model.api.shortcut.ShortcutType;
import com.ubnt.model.api.shortcut.ToggleShortcutDto;
import jakarta.validation.constraints.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", defaultImpl=ToggleShortcutDto.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FeatureShortcutDto.class, name="FEATURE"), @JsonSubTypes.Type(value=ToggleShortcutDto.class, names={"WIFI", "NETWORK", "VPN_SERVER", "VPN_CLIENT", "S2S_VPN", "POLICY_BASED_ROUTING", "PORT_FORWARDING"})})
public interface ShortcutDto {
    @NotNull
    @JsonProperty(value="id")
    public String id();

    @NotNull
    @JsonProperty(value="type")
    public ShortcutType type();

    default public X toLegacy() {
        return new X().append("id", this.id()).append("type", (Object)this.type());
    }

    public static ShortcutDto from(X x2) {
        ShortcutType shortcutType = x2.getOptionalEnum("type", ShortcutType.class).orElseThrow();
        return switch (shortcutType) {
            default -> throw new IncompatibleClassChangeError();
            case ShortcutType.WIFI, ShortcutType.NETWORK, ShortcutType.POLICY_BASED_ROUTING, ShortcutType.PORT_FORWARDING, ShortcutType.S2S_VPN, ShortcutType.VPN_SERVER, ShortcutType.VPN_CLIENT -> ToggleShortcutDto.from(shortcutType, x2);
            case ShortcutType.FEATURE -> FeatureShortcutDto.from(shortcutType, x2);
        };
    }
}

