// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/spanner/adapter/v1/adapter.proto

package adapterpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Adapter_CreateSession_FullMethodName = "/google.spanner.adapter.v1.Adapter/CreateSession"
	Adapter_AdaptMessage_FullMethodName  = "/google.spanner.adapter.v1.Adapter/AdaptMessage"
)

// AdapterClient is the client API for Adapter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AdapterClient interface {
	// Creates a new session to be used for requests made by the adapter.
	// A session identifies a specific incarnation of a database resource and is
	// meant to be reused across many `AdaptMessage` calls.
	CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error)
	// Handles a single message from the client and returns the result as a
	// stream. The server will interpret the message frame and respond with
	// message frames to the client.
	AdaptMessage(ctx context.Context, in *AdaptMessageRequest, opts ...grpc.CallOption) (Adapter_AdaptMessageClient, error)
}

type adapterClient struct {
	cc grpc.ClientConnInterface
}

func NewAdapterClient(cc grpc.ClientConnInterface) AdapterClient {
	return &adapterClient{cc}
}

func (c *adapterClient) CreateSession(ctx context.Context, in *CreateSessionRequest, opts ...grpc.CallOption) (*Session, error) {
	out := new(Session)
	err := c.cc.Invoke(ctx, Adapter_CreateSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adapterClient) AdaptMessage(ctx context.Context, in *AdaptMessageRequest, opts ...grpc.CallOption) (Adapter_AdaptMessageClient, error) {
	stream, err := c.cc.NewStream(ctx, &Adapter_ServiceDesc.Streams[0], Adapter_AdaptMessage_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &adapterAdaptMessageClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Adapter_AdaptMessageClient interface {
	Recv() (*AdaptMessageResponse, error)
	grpc.ClientStream
}

type adapterAdaptMessageClient struct {
	grpc.ClientStream
}

func (x *adapterAdaptMessageClient) Recv() (*AdaptMessageResponse, error) {
	m := new(AdaptMessageResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// AdapterServer is the server API for Adapter service.
// All implementations should embed UnimplementedAdapterServer
// for forward compatibility
type AdapterServer interface {
	// Creates a new session to be used for requests made by the adapter.
	// A session identifies a specific incarnation of a database resource and is
	// meant to be reused across many `AdaptMessage` calls.
	CreateSession(context.Context, *CreateSessionRequest) (*Session, error)
	// Handles a single message from the client and returns the result as a
	// stream. The server will interpret the message frame and respond with
	// message frames to the client.
	AdaptMessage(*AdaptMessageRequest, Adapter_AdaptMessageServer) error
}

// UnimplementedAdapterServer should be embedded to have forward compatible implementations.
type UnimplementedAdapterServer struct {
}

func (UnimplementedAdapterServer) CreateSession(context.Context, *CreateSessionRequest) (*Session, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSession not implemented")
}
func (UnimplementedAdapterServer) AdaptMessage(*AdaptMessageRequest, Adapter_AdaptMessageServer) error {
	return status.Errorf(codes.Unimplemented, "method AdaptMessage not implemented")
}

// UnsafeAdapterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AdapterServer will
// result in compilation errors.
type UnsafeAdapterServer interface {
	mustEmbedUnimplementedAdapterServer()
}

func RegisterAdapterServer(s grpc.ServiceRegistrar, srv AdapterServer) {
	s.RegisterService(&Adapter_ServiceDesc, srv)
}

func _Adapter_CreateSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdapterServer).CreateSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Adapter_CreateSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdapterServer).CreateSession(ctx, req.(*CreateSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Adapter_AdaptMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(AdaptMessageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AdapterServer).AdaptMessage(m, &adapterAdaptMessageServer{stream})
}

type Adapter_AdaptMessageServer interface {
	Send(*AdaptMessageResponse) error
	grpc.ServerStream
}

type adapterAdaptMessageServer struct {
	grpc.ServerStream
}

func (x *adapterAdaptMessageServer) Send(m *AdaptMessageResponse) error {
	return x.ServerStream.SendMsg(m)
}

// Adapter_ServiceDesc is the grpc.ServiceDesc for Adapter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Adapter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.adapter.v1.Adapter",
	HandlerType: (*AdapterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSession",
			Handler:    _Adapter_CreateSession_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "AdaptMessage",
			Handler:       _Adapter_AdaptMessage_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/spanner/adapter/v1/adapter.proto",
}
