/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sns.model.ListOfPlatformApplicationsCopier;
import software.amazon.awssdk.services.sns.model.PlatformApplication;
import software.amazon.awssdk.services.sns.model.SnsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlatformApplicationsResponse
extends SnsResponse
implements ToCopyableBuilder<Builder, ListPlatformApplicationsResponse> {
    private static final SdkField<List<PlatformApplication>> PLATFORM_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PlatformApplications").getter(ListPlatformApplicationsResponse.getter(ListPlatformApplicationsResponse::platformApplications)).setter(ListPlatformApplicationsResponse.setter(Builder::platformApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PlatformApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPlatformApplicationsResponse.getter(ListPlatformApplicationsResponse::nextToken)).setter(ListPlatformApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_APPLICATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPlatformApplicationsResponse.memberNameToFieldInitializer();
    private final List<PlatformApplication> platformApplications;
    private final String nextToken;

    private ListPlatformApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.platformApplications = builder.platformApplications;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPlatformApplications() {
        return this.platformApplications != null && !(this.platformApplications instanceof SdkAutoConstructList);
    }

    public final List<PlatformApplication> platformApplications() {
        return this.platformApplications;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformApplications() ? this.platformApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlatformApplicationsResponse)) {
            return false;
        }
        ListPlatformApplicationsResponse other = (ListPlatformApplicationsResponse)((Object)obj);
        return this.hasPlatformApplications() == other.hasPlatformApplications() && Objects.equals(this.platformApplications(), other.platformApplications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPlatformApplicationsResponse").add("PlatformApplications", this.hasPlatformApplications() ? this.platformApplications() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlatformApplications": {
                return Optional.ofNullable(clazz.cast(this.platformApplications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlatformApplications", PLATFORM_APPLICATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPlatformApplicationsResponse, T> g) {
        return obj -> g.apply((ListPlatformApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnsResponse.BuilderImpl
    implements Builder {
        private List<PlatformApplication> platformApplications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlatformApplicationsResponse model) {
            super(model);
            this.platformApplications(model.platformApplications);
            this.nextToken(model.nextToken);
        }

        public final List<PlatformApplication.Builder> getPlatformApplications() {
            List<PlatformApplication.Builder> result = ListOfPlatformApplicationsCopier.copyToBuilder(this.platformApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlatformApplications(Collection<PlatformApplication.BuilderImpl> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copyFromBuilder(platformApplications);
        }

        @Override
        public final Builder platformApplications(Collection<PlatformApplication> platformApplications) {
            this.platformApplications = ListOfPlatformApplicationsCopier.copy(platformApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformApplications(PlatformApplication ... platformApplications) {
            this.platformApplications(Arrays.asList(platformApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformApplications(Consumer<PlatformApplication.Builder> ... platformApplications) {
            this.platformApplications(Stream.of(platformApplications).map(c -> (PlatformApplication)((PlatformApplication.Builder)PlatformApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPlatformApplicationsResponse build() {
            return new ListPlatformApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SnsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlatformApplicationsResponse> {
        public Builder platformApplications(Collection<PlatformApplication> var1);

        public Builder platformApplications(PlatformApplication ... var1);

        public Builder platformApplications(Consumer<PlatformApplication.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

