// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigScopeProfiles()
				CopyOrigScopeProfiles(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigScopeProfiles(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigScopeProfilesUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigScopeProfiles()
	UnmarshalJSONOrigScopeProfiles(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigScopeProfiles(), dest)
}

func TestMarshalAndUnmarshalJSONOrigScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigScopeProfiles(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigScopeProfiles()
				UnmarshalJSONOrigScopeProfiles(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigScopeProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeProfilesFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesScopeProfiles() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigScopeProfiles()
			require.Error(t, UnmarshalProtoOrigScopeProfiles(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigScopeProfilesUnknown(t *testing.T) {
	dest := NewOrigScopeProfiles()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigScopeProfiles(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigScopeProfiles(), dest)
}

func TestMarshalAndUnmarshalProtoOrigScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigScopeProfiles(src))
				gotSize := MarshalProtoOrigScopeProfiles(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigScopeProfiles()
				require.NoError(t, UnmarshalProtoOrigScopeProfiles(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigScopeProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufScopeProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesScopeProfiles() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigScopeProfiles(src))
			gotSize := MarshalProtoOrigScopeProfiles(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ScopeProfiles{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigScopeProfiles()
			require.NoError(t, UnmarshalProtoOrigScopeProfiles(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesScopeProfiles() map[string][]byte {
	return map[string][]byte{
		"invalid_field":             {0x02},
		"Scope/wrong_wire_type":     {0xc},
		"Scope/missing_value":       {0xa},
		"Profiles/wrong_wire_type":  {0x14},
		"Profiles/missing_value":    {0x12},
		"SchemaUrl/wrong_wire_type": {0x1c},
		"SchemaUrl/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesScopeProfiles() map[string]*otlpprofiles.ScopeProfiles {
	return map[string]*otlpprofiles.ScopeProfiles{
		"empty":                     NewOrigScopeProfiles(),
		"Scope/test":                {Scope: *GenTestOrigInstrumentationScope()},
		"Profiles/default_and_test": {Profiles: []*otlpprofiles.Profile{{}, GenTestOrigProfile()}},
		"SchemaUrl/test":            {SchemaUrl: "test_schemaurl"},
	}
}
