/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.avgroup;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.avgroup.AvGroupClientDto;
import com.ubnt.model.api.avgroup.AvGroupDto;
import com.ubnt.service.avgroup.AvGroupClientDocumentPart;
import com.ubnt.service.avgroup.AvGroupDocument;
import com.ubnt.service.avgroup.do;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public final class AvGroupMatrixDto {
    @JsonProperty(value="groups")
    @Valid
    @NotNull
    @NotEmpty
    private final List<AvGroupDto> groups;
    @JsonProperty(value="hosts")
    @NotNull
    @NotEmpty
    private final Set<String> hosts;
    @JsonProperty(value="clients")
    @NotNull
    @NotEmpty
    private final Set<String> clients;
    @JsonProperty(value="bridges")
    @NotNull
    @NotEmpty
    private final Set<String> bridges;
    @JsonProperty(value="host_candidates")
    @NotNull
    @NotEmpty
    private final Set<String> hostCandidates;
    @JsonProperty(value="client_candidates")
    @NotNull
    @NotEmpty
    private final Set<String> clientCandidates;

    public static AvGroupMatrixDto fromDocument(do do_, List<AvGroupDocument> list, Collection<String> collection, Collection<String> collection2) {
        Collection<String> collection3;
        ArrayList<AvGroupDto> arrayList = new ArrayList<AvGroupDto>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (AvGroupDocument object2 : list) {
            if (object2.getType() == do_) {
                arrayList.add(AvGroupDto.fromDocument(object2));
                continue;
            }
            hashSet.add(object2.getHost().getMac());
            collection3 = object2.getClients().stream().map(AvGroupClientDocumentPart::getMac).toList();
            hashSet2.addAll(collection3);
        }
        Set set = Stream.concat(collection.stream(), collection2.stream()).collect(Collectors.toSet());
        Set set2 = arrayList.stream().flatMap(avGroupDto -> Stream.concat(Stream.of(avGroupDto.getHost().getMac()), avGroupDto.getClients().stream().map(AvGroupClientDto::getMac))).collect(Collectors.toSet());
        collection3 = new HashSet();
        HashSet<String> hashSet3 = new HashSet<String>();
        set.stream().filter(string -> !set2.contains(string)).forEach(string -> {
            if (!hashSet.contains(string)) {
                hashSet3.add((String)string);
            }
            if (!hashSet2.contains(string)) {
                collection3.add((String)string);
            }
        });
        return AvGroupMatrixDto.builder().groups(arrayList).hosts(Set.copyOf(collection)).clients(Set.copyOf(collection2)).hostCandidates((Set<String>)collection3).clientCandidates(hashSet3).bridges(set).build();
    }

    @ConstructorProperties(value={"groups", "hosts", "clients", "bridges", "hostCandidates", "clientCandidates"})
    @Generated
    AvGroupMatrixDto(@JsonProperty(value="groups") List<AvGroupDto> list, @JsonProperty(value="hosts") Set<String> set, @JsonProperty(value="clients") Set<String> set2, @JsonProperty(value="bridges") Set<String> set3, @JsonProperty(value="host_candidates") Set<String> set4, @JsonProperty(value="client_candidates") Set<String> set5) {
        this.groups = list;
        this.hosts = set;
        this.clients = set2;
        this.bridges = set3;
        this.hostCandidates = set4;
        this.clientCandidates = set5;
    }

    @Generated
    public static AvGroupMatrixDtoBuilder builder() {
        return new AvGroupMatrixDtoBuilder();
    }

    @JsonProperty(value="groups")
    @Generated
    public List<AvGroupDto> getGroups() {
        return this.groups;
    }

    @JsonProperty(value="hosts")
    @Generated
    public Set<String> getHosts() {
        return this.hosts;
    }

    @JsonProperty(value="clients")
    @Generated
    public Set<String> getClients() {
        return this.clients;
    }

    @JsonProperty(value="bridges")
    @Generated
    public Set<String> getBridges() {
        return this.bridges;
    }

    @JsonProperty(value="host_candidates")
    @Generated
    public Set<String> getHostCandidates() {
        return this.hostCandidates;
    }

    @JsonProperty(value="client_candidates")
    @Generated
    public Set<String> getClientCandidates() {
        return this.clientCandidates;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AvGroupMatrixDto)) {
            return false;
        }
        AvGroupMatrixDto avGroupMatrixDto = (AvGroupMatrixDto)object;
        List<AvGroupDto> list = this.getGroups();
        List<AvGroupDto> list2 = avGroupMatrixDto.getGroups();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        Set<String> set = this.getHosts();
        Set<String> set2 = avGroupMatrixDto.getHosts();
        if (set == null ? set2 != null : !((Object)set).equals(set2)) {
            return false;
        }
        Set<String> set3 = this.getClients();
        Set<String> set4 = avGroupMatrixDto.getClients();
        if (set3 == null ? set4 != null : !((Object)set3).equals(set4)) {
            return false;
        }
        Set<String> set5 = this.getBridges();
        Set<String> set6 = avGroupMatrixDto.getBridges();
        if (set5 == null ? set6 != null : !((Object)set5).equals(set6)) {
            return false;
        }
        Set<String> set7 = this.getHostCandidates();
        Set<String> set8 = avGroupMatrixDto.getHostCandidates();
        if (set7 == null ? set8 != null : !((Object)set7).equals(set8)) {
            return false;
        }
        Set<String> set9 = this.getClientCandidates();
        Set<String> set10 = avGroupMatrixDto.getClientCandidates();
        return !(set9 == null ? set10 != null : !((Object)set9).equals(set10));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        List<AvGroupDto> list = this.getGroups();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        Set<String> set = this.getHosts();
        n2 = n2 * 59 + (set == null ? 43 : ((Object)set).hashCode());
        Set<String> set2 = this.getClients();
        n2 = n2 * 59 + (set2 == null ? 43 : ((Object)set2).hashCode());
        Set<String> set3 = this.getBridges();
        n2 = n2 * 59 + (set3 == null ? 43 : ((Object)set3).hashCode());
        Set<String> set4 = this.getHostCandidates();
        n2 = n2 * 59 + (set4 == null ? 43 : ((Object)set4).hashCode());
        Set<String> set5 = this.getClientCandidates();
        n2 = n2 * 59 + (set5 == null ? 43 : ((Object)set5).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "AvGroupMatrixDto(groups=" + String.valueOf(this.getGroups()) + ", hosts=" + String.valueOf(this.getHosts()) + ", clients=" + String.valueOf(this.getClients()) + ", bridges=" + String.valueOf(this.getBridges()) + ", hostCandidates=" + String.valueOf(this.getHostCandidates()) + ", clientCandidates=" + String.valueOf(this.getClientCandidates()) + ")";
    }

    @Generated
    public AvGroupMatrixDto withGroups(@JsonProperty(value="groups") List<AvGroupDto> list) {
        return this.groups == list ? this : new AvGroupMatrixDto(list, this.hosts, this.clients, this.bridges, this.hostCandidates, this.clientCandidates);
    }

    @Generated
    public AvGroupMatrixDto withHosts(@JsonProperty(value="hosts") Set<String> set) {
        return this.hosts == set ? this : new AvGroupMatrixDto(this.groups, set, this.clients, this.bridges, this.hostCandidates, this.clientCandidates);
    }

    @Generated
    public AvGroupMatrixDto withClients(@JsonProperty(value="clients") Set<String> set) {
        return this.clients == set ? this : new AvGroupMatrixDto(this.groups, this.hosts, set, this.bridges, this.hostCandidates, this.clientCandidates);
    }

    @Generated
    public AvGroupMatrixDto withBridges(@JsonProperty(value="bridges") Set<String> set) {
        return this.bridges == set ? this : new AvGroupMatrixDto(this.groups, this.hosts, this.clients, set, this.hostCandidates, this.clientCandidates);
    }

    @Generated
    public AvGroupMatrixDto withHostCandidates(@JsonProperty(value="host_candidates") Set<String> set) {
        return this.hostCandidates == set ? this : new AvGroupMatrixDto(this.groups, this.hosts, this.clients, this.bridges, set, this.clientCandidates);
    }

    @Generated
    public AvGroupMatrixDto withClientCandidates(@JsonProperty(value="client_candidates") Set<String> set) {
        return this.clientCandidates == set ? this : new AvGroupMatrixDto(this.groups, this.hosts, this.clients, this.bridges, this.hostCandidates, set);
    }

    @Generated
    public static class AvGroupMatrixDtoBuilder {
        @Generated
        private List<AvGroupDto> groups;
        @Generated
        private Set<String> hosts;
        @Generated
        private Set<String> clients;
        @Generated
        private Set<String> bridges;
        @Generated
        private Set<String> hostCandidates;
        @Generated
        private Set<String> clientCandidates;

        @Generated
        AvGroupMatrixDtoBuilder() {
        }

        @JsonProperty(value="groups")
        @Generated
        public AvGroupMatrixDtoBuilder groups(@JsonProperty(value="groups") List<AvGroupDto> list) {
            this.groups = list;
            return this;
        }

        @JsonProperty(value="hosts")
        @Generated
        public AvGroupMatrixDtoBuilder hosts(@JsonProperty(value="hosts") Set<String> set) {
            this.hosts = set;
            return this;
        }

        @JsonProperty(value="clients")
        @Generated
        public AvGroupMatrixDtoBuilder clients(@JsonProperty(value="clients") Set<String> set) {
            this.clients = set;
            return this;
        }

        @JsonProperty(value="bridges")
        @Generated
        public AvGroupMatrixDtoBuilder bridges(@JsonProperty(value="bridges") Set<String> set) {
            this.bridges = set;
            return this;
        }

        @JsonProperty(value="host_candidates")
        @Generated
        public AvGroupMatrixDtoBuilder hostCandidates(@JsonProperty(value="host_candidates") Set<String> set) {
            this.hostCandidates = set;
            return this;
        }

        @JsonProperty(value="client_candidates")
        @Generated
        public AvGroupMatrixDtoBuilder clientCandidates(@JsonProperty(value="client_candidates") Set<String> set) {
            this.clientCandidates = set;
            return this;
        }

        @Generated
        public AvGroupMatrixDto build() {
            return new AvGroupMatrixDto(this.groups, this.hosts, this.clients, this.bridges, this.hostCandidates, this.clientCandidates);
        }

        @Generated
        public String toString() {
            return "AvGroupMatrixDto.AvGroupMatrixDtoBuilder(groups=" + String.valueOf(this.groups) + ", hosts=" + String.valueOf(this.hosts) + ", clients=" + String.valueOf(this.clients) + ", bridges=" + String.valueOf(this.bridges) + ", hostCandidates=" + String.valueOf(this.hostCandidates) + ", clientCandidates=" + String.valueOf(this.clientCandidates) + ")";
        }
    }
}

