testdata
========

The files in this directory serve as test fixtures, used for validating that
the `mkbench` command produces the expected output when reading and writing
various Pebble benchmark data.

The data was generated by downloading a sample of existing raw benchmark log
data from the
[`pebble-benchmarks`](https://s3.console.aws.amazon.com/s3/buckets/pebble-benchmarks)
S3 bucket. The data was trimmed so as to reduce the amount of data checked into
version control, with something akin to:

```bash
for _file in $(find "$DOWNLOADED_DATA" -name '*.gz'); do
  gunzip --to-stdout "$_file" \
    | grep 'Benchmarkycsb' -B 10 -A 10 \
    | gzip > "$OUTPUT_DIR/$(basename "$_file")"
done
```
