// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Terminates (deletes) the specified instances. This operation is [idempotent]; if you
// terminate an instance more than once, each call succeeds.
//
// Terminating an instance is permanent and irreversible.
//
// After you terminate an instance, you can no longer connect to it, and it can't
// be recovered. All attached Amazon EBS volumes that are configured to be deleted
// on termination are also permanently deleted and can't be recovered. All data
// stored on instance store volumes is permanently lost. For more information, see [How instance termination works]
// .
//
// Before you terminate an instance, ensure that you have backed up all data that
// you need to retain after the termination to persistent storage.
//
// If you specify multiple instances and the request fails (for example, because
// of a single incorrect instance ID), none of the instances are terminated.
//
// If you terminate multiple instances across multiple Availability Zones, and one
// or more of the specified instances are enabled for termination protection, the
// request fails with the following results:
//
//   - The specified instances that are in the same Availability Zone as the
//     protected instance are not terminated.
//
//   - The specified instances that are in different Availability Zones, where no
//     other specified instances are protected, are successfully terminated.
//
// For example, say you have the following instances:
//
//   - Instance A: us-east-1a ; Not protected
//
//   - Instance B: us-east-1a ; Not protected
//
//   - Instance C: us-east-1b ; Protected
//
//   - Instance D: us-east-1b ; not protected
//
// If you attempt to terminate all of these instances in the same request, the
// request reports failure with the following results:
//
//   - Instance A and Instance B are successfully terminated because none of the
//     specified instances in us-east-1a are enabled for termination protection.
//
//   - Instance C and Instance D fail to terminate because at least one of the
//     specified instances in us-east-1b (Instance C) is enabled for termination
//     protection.
//
// Terminated instances remain visible after termination (for approximately one
// hour).
//
// By default, Amazon EC2 deletes all EBS volumes that were attached when the
// instance launched. Volumes attached after instance launch continue running.
//
// By default, the TerminateInstances operation includes a graceful operating
// system (OS) shutdown. To bypass the graceful shutdown, use the skipOsShutdown
// parameter; however, this might risk data integrity.
//
// You can stop, start, and terminate EBS-backed instances. You can only terminate
// instance store-backed instances. What happens to an instance differs if you stop
// or terminate it. For example, when you stop an instance, the root device and any
// other devices attached to the instance persist. When you terminate an instance,
// any attached EBS volumes with the DeleteOnTermination block device mapping
// parameter set to true are automatically deleted. For more information about the
// differences between stopping and terminating instances, see [Amazon EC2 instance state changes]in the Amazon EC2
// User Guide.
//
// When you terminate an instance, we attempt to terminate it forcibly after a
// short while. If your instance appears stuck in the shutting-down state after a
// period of time, there might be an issue with the underlying host computer. For
// more information about terminating and troubleshooting terminating your
// instances, see [Terminate Amazon EC2 instances]and [Troubleshooting terminating your instance] in the Amazon EC2 User Guide.
//
// [idempotent]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
// [How instance termination works]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-ec2-instance-termination-works.html
// [Troubleshooting terminating your instance]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html
// [Amazon EC2 instance state changes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html
// [Terminate Amazon EC2 instances]: https://docs.aws.amazon.com/
func (c *Client) TerminateInstances(ctx context.Context, params *TerminateInstancesInput, optFns ...func(*Options)) (*TerminateInstancesOutput, error) {
	if params == nil {
		params = &TerminateInstancesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TerminateInstances", params, optFns, c.addOperationTerminateInstancesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TerminateInstancesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TerminateInstancesInput struct {

	// The IDs of the instances.
	//
	// Constraints: Up to 1000 instance IDs. We recommend breaking up this request
	// into smaller batches.
	//
	// This member is required.
	InstanceIds []string

	// Checks whether you have the required permissions for the operation, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Forces the instances to terminate. The instance will first attempt a graceful
	// shutdown, which includes flushing file system caches and metadata. If the
	// graceful shutdown fails to complete within the timeout period, the instance
	// shuts down forcibly without flushing the file system caches and metadata.
	Force *bool

	// Specifies whether to bypass the graceful OS shutdown process when the instance
	// is terminated.
	//
	// Default: false
	SkipOsShutdown *bool

	noSmithyDocumentSerde
}

type TerminateInstancesOutput struct {

	// Information about the terminated instances.
	TerminatingInstances []types.InstanceStateChange

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTerminateInstancesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpTerminateInstances{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpTerminateInstances{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TerminateInstances"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpTerminateInstancesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTerminateInstances(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTerminateInstances(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TerminateInstances",
	}
}
