// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/metastore/v1beta/metastore.proto

package metastorepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataprocMetastore_ListServices_FullMethodName                  = "/google.cloud.metastore.v1beta.DataprocMetastore/ListServices"
	DataprocMetastore_GetService_FullMethodName                    = "/google.cloud.metastore.v1beta.DataprocMetastore/GetService"
	DataprocMetastore_CreateService_FullMethodName                 = "/google.cloud.metastore.v1beta.DataprocMetastore/CreateService"
	DataprocMetastore_UpdateService_FullMethodName                 = "/google.cloud.metastore.v1beta.DataprocMetastore/UpdateService"
	DataprocMetastore_DeleteService_FullMethodName                 = "/google.cloud.metastore.v1beta.DataprocMetastore/DeleteService"
	DataprocMetastore_ListMetadataImports_FullMethodName           = "/google.cloud.metastore.v1beta.DataprocMetastore/ListMetadataImports"
	DataprocMetastore_GetMetadataImport_FullMethodName             = "/google.cloud.metastore.v1beta.DataprocMetastore/GetMetadataImport"
	DataprocMetastore_CreateMetadataImport_FullMethodName          = "/google.cloud.metastore.v1beta.DataprocMetastore/CreateMetadataImport"
	DataprocMetastore_UpdateMetadataImport_FullMethodName          = "/google.cloud.metastore.v1beta.DataprocMetastore/UpdateMetadataImport"
	DataprocMetastore_ExportMetadata_FullMethodName                = "/google.cloud.metastore.v1beta.DataprocMetastore/ExportMetadata"
	DataprocMetastore_RestoreService_FullMethodName                = "/google.cloud.metastore.v1beta.DataprocMetastore/RestoreService"
	DataprocMetastore_ListBackups_FullMethodName                   = "/google.cloud.metastore.v1beta.DataprocMetastore/ListBackups"
	DataprocMetastore_GetBackup_FullMethodName                     = "/google.cloud.metastore.v1beta.DataprocMetastore/GetBackup"
	DataprocMetastore_CreateBackup_FullMethodName                  = "/google.cloud.metastore.v1beta.DataprocMetastore/CreateBackup"
	DataprocMetastore_DeleteBackup_FullMethodName                  = "/google.cloud.metastore.v1beta.DataprocMetastore/DeleteBackup"
	DataprocMetastore_RemoveIamPolicy_FullMethodName               = "/google.cloud.metastore.v1beta.DataprocMetastore/RemoveIamPolicy"
	DataprocMetastore_QueryMetadata_FullMethodName                 = "/google.cloud.metastore.v1beta.DataprocMetastore/QueryMetadata"
	DataprocMetastore_MoveTableToDatabase_FullMethodName           = "/google.cloud.metastore.v1beta.DataprocMetastore/MoveTableToDatabase"
	DataprocMetastore_AlterMetadataResourceLocation_FullMethodName = "/google.cloud.metastore.v1beta.DataprocMetastore/AlterMetadataResourceLocation"
)

// DataprocMetastoreClient is the client API for DataprocMetastore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataprocMetastoreClient interface {
	// Lists services in a project and location.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets the details of a single service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Creates a metastore service in a project and location.
	CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single service.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single service.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists imports in a service.
	ListMetadataImports(ctx context.Context, in *ListMetadataImportsRequest, opts ...grpc.CallOption) (*ListMetadataImportsResponse, error)
	// Gets details of a single import.
	GetMetadataImport(ctx context.Context, in *GetMetadataImportRequest, opts ...grpc.CallOption) (*MetadataImport, error)
	// Creates a new MetadataImport in a given project and location.
	CreateMetadataImport(ctx context.Context, in *CreateMetadataImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a single import.
	// Only the description field of MetadataImport is supported to be updated.
	UpdateMetadataImport(ctx context.Context, in *UpdateMetadataImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports metadata from a service.
	ExportMetadata(ctx context.Context, in *ExportMetadataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores a service from a backup.
	RestoreService(ctx context.Context, in *RestoreServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists backups in a service.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Gets details of a single backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Creates a new backup in a given project and location.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes the attached IAM policies for a resource
	RemoveIamPolicy(ctx context.Context, in *RemoveIamPolicyRequest, opts ...grpc.CallOption) (*RemoveIamPolicyResponse, error)
	// Query DPMS metadata.
	QueryMetadata(ctx context.Context, in *QueryMetadataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Move a table to another database.
	MoveTableToDatabase(ctx context.Context, in *MoveTableToDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Alter metadata resource location. The metadata resource can be a database,
	// table, or partition. This functionality only updates the parent directory
	// for the respective metadata resource and does not transfer any existing
	// data to the new location.
	AlterMetadataResourceLocation(ctx context.Context, in *AlterMetadataResourceLocationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type dataprocMetastoreClient struct {
	cc grpc.ClientConnInterface
}

func NewDataprocMetastoreClient(cc grpc.ClientConnInterface) DataprocMetastoreClient {
	return &dataprocMetastoreClient{cc}
}

func (c *dataprocMetastoreClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := c.cc.Invoke(ctx, DataprocMetastore_ListServices_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := c.cc.Invoke(ctx, DataprocMetastore_GetService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) CreateService(ctx context.Context, in *CreateServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_CreateService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_UpdateService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_DeleteService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) ListMetadataImports(ctx context.Context, in *ListMetadataImportsRequest, opts ...grpc.CallOption) (*ListMetadataImportsResponse, error) {
	out := new(ListMetadataImportsResponse)
	err := c.cc.Invoke(ctx, DataprocMetastore_ListMetadataImports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) GetMetadataImport(ctx context.Context, in *GetMetadataImportRequest, opts ...grpc.CallOption) (*MetadataImport, error) {
	out := new(MetadataImport)
	err := c.cc.Invoke(ctx, DataprocMetastore_GetMetadataImport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) CreateMetadataImport(ctx context.Context, in *CreateMetadataImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_CreateMetadataImport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) UpdateMetadataImport(ctx context.Context, in *UpdateMetadataImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_UpdateMetadataImport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) ExportMetadata(ctx context.Context, in *ExportMetadataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_ExportMetadata_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) RestoreService(ctx context.Context, in *RestoreServiceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_RestoreService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, DataprocMetastore_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, DataprocMetastore_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_CreateBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) RemoveIamPolicy(ctx context.Context, in *RemoveIamPolicyRequest, opts ...grpc.CallOption) (*RemoveIamPolicyResponse, error) {
	out := new(RemoveIamPolicyResponse)
	err := c.cc.Invoke(ctx, DataprocMetastore_RemoveIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) QueryMetadata(ctx context.Context, in *QueryMetadataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_QueryMetadata_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) MoveTableToDatabase(ctx context.Context, in *MoveTableToDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_MoveTableToDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataprocMetastoreClient) AlterMetadataResourceLocation(ctx context.Context, in *AlterMetadataResourceLocationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DataprocMetastore_AlterMetadataResourceLocation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataprocMetastoreServer is the server API for DataprocMetastore service.
// All implementations should embed UnimplementedDataprocMetastoreServer
// for forward compatibility
type DataprocMetastoreServer interface {
	// Lists services in a project and location.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets the details of a single service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// Creates a metastore service in a project and location.
	CreateService(context.Context, *CreateServiceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single service.
	UpdateService(context.Context, *UpdateServiceRequest) (*longrunningpb.Operation, error)
	// Deletes a single service.
	DeleteService(context.Context, *DeleteServiceRequest) (*longrunningpb.Operation, error)
	// Lists imports in a service.
	ListMetadataImports(context.Context, *ListMetadataImportsRequest) (*ListMetadataImportsResponse, error)
	// Gets details of a single import.
	GetMetadataImport(context.Context, *GetMetadataImportRequest) (*MetadataImport, error)
	// Creates a new MetadataImport in a given project and location.
	CreateMetadataImport(context.Context, *CreateMetadataImportRequest) (*longrunningpb.Operation, error)
	// Updates a single import.
	// Only the description field of MetadataImport is supported to be updated.
	UpdateMetadataImport(context.Context, *UpdateMetadataImportRequest) (*longrunningpb.Operation, error)
	// Exports metadata from a service.
	ExportMetadata(context.Context, *ExportMetadataRequest) (*longrunningpb.Operation, error)
	// Restores a service from a backup.
	RestoreService(context.Context, *RestoreServiceRequest) (*longrunningpb.Operation, error)
	// Lists backups in a service.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Gets details of a single backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Creates a new backup in a given project and location.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Deletes a single backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Removes the attached IAM policies for a resource
	RemoveIamPolicy(context.Context, *RemoveIamPolicyRequest) (*RemoveIamPolicyResponse, error)
	// Query DPMS metadata.
	QueryMetadata(context.Context, *QueryMetadataRequest) (*longrunningpb.Operation, error)
	// Move a table to another database.
	MoveTableToDatabase(context.Context, *MoveTableToDatabaseRequest) (*longrunningpb.Operation, error)
	// Alter metadata resource location. The metadata resource can be a database,
	// table, or partition. This functionality only updates the parent directory
	// for the respective metadata resource and does not transfer any existing
	// data to the new location.
	AlterMetadataResourceLocation(context.Context, *AlterMetadataResourceLocationRequest) (*longrunningpb.Operation, error)
}

// UnimplementedDataprocMetastoreServer should be embedded to have forward compatible implementations.
type UnimplementedDataprocMetastoreServer struct {
}

func (UnimplementedDataprocMetastoreServer) ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServices not implemented")
}
func (UnimplementedDataprocMetastoreServer) GetService(context.Context, *GetServiceRequest) (*Service, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetService not implemented")
}
func (UnimplementedDataprocMetastoreServer) CreateService(context.Context, *CreateServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateService not implemented")
}
func (UnimplementedDataprocMetastoreServer) UpdateService(context.Context, *UpdateServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateService not implemented")
}
func (UnimplementedDataprocMetastoreServer) DeleteService(context.Context, *DeleteServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteService not implemented")
}
func (UnimplementedDataprocMetastoreServer) ListMetadataImports(context.Context, *ListMetadataImportsRequest) (*ListMetadataImportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMetadataImports not implemented")
}
func (UnimplementedDataprocMetastoreServer) GetMetadataImport(context.Context, *GetMetadataImportRequest) (*MetadataImport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetadataImport not implemented")
}
func (UnimplementedDataprocMetastoreServer) CreateMetadataImport(context.Context, *CreateMetadataImportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMetadataImport not implemented")
}
func (UnimplementedDataprocMetastoreServer) UpdateMetadataImport(context.Context, *UpdateMetadataImportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMetadataImport not implemented")
}
func (UnimplementedDataprocMetastoreServer) ExportMetadata(context.Context, *ExportMetadataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportMetadata not implemented")
}
func (UnimplementedDataprocMetastoreServer) RestoreService(context.Context, *RestoreServiceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreService not implemented")
}
func (UnimplementedDataprocMetastoreServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedDataprocMetastoreServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedDataprocMetastoreServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (UnimplementedDataprocMetastoreServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedDataprocMetastoreServer) RemoveIamPolicy(context.Context, *RemoveIamPolicyRequest) (*RemoveIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveIamPolicy not implemented")
}
func (UnimplementedDataprocMetastoreServer) QueryMetadata(context.Context, *QueryMetadataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryMetadata not implemented")
}
func (UnimplementedDataprocMetastoreServer) MoveTableToDatabase(context.Context, *MoveTableToDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveTableToDatabase not implemented")
}
func (UnimplementedDataprocMetastoreServer) AlterMetadataResourceLocation(context.Context, *AlterMetadataResourceLocationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AlterMetadataResourceLocation not implemented")
}

// UnsafeDataprocMetastoreServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataprocMetastoreServer will
// result in compilation errors.
type UnsafeDataprocMetastoreServer interface {
	mustEmbedUnimplementedDataprocMetastoreServer()
}

func RegisterDataprocMetastoreServer(s grpc.ServiceRegistrar, srv DataprocMetastoreServer) {
	s.RegisterService(&DataprocMetastore_ServiceDesc, srv)
}

func _DataprocMetastore_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_ListServices_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_GetService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_CreateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).CreateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_CreateService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).CreateService(ctx, req.(*CreateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_UpdateService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_DeleteService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_ListMetadataImports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMetadataImportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ListMetadataImports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_ListMetadataImports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ListMetadataImports(ctx, req.(*ListMetadataImportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_GetMetadataImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetadataImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).GetMetadataImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_GetMetadataImport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).GetMetadataImport(ctx, req.(*GetMetadataImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_CreateMetadataImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMetadataImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).CreateMetadataImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_CreateMetadataImport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).CreateMetadataImport(ctx, req.(*CreateMetadataImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_UpdateMetadataImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMetadataImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).UpdateMetadataImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_UpdateMetadataImport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).UpdateMetadataImport(ctx, req.(*UpdateMetadataImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_ExportMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ExportMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_ExportMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ExportMetadata(ctx, req.(*ExportMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_RestoreService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).RestoreService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_RestoreService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).RestoreService(ctx, req.(*RestoreServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_CreateBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_RemoveIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).RemoveIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_RemoveIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).RemoveIamPolicy(ctx, req.(*RemoveIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_QueryMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryMetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).QueryMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_QueryMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).QueryMetadata(ctx, req.(*QueryMetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_MoveTableToDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveTableToDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).MoveTableToDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_MoveTableToDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).MoveTableToDatabase(ctx, req.(*MoveTableToDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataprocMetastore_AlterMetadataResourceLocation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AlterMetadataResourceLocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataprocMetastoreServer).AlterMetadataResourceLocation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataprocMetastore_AlterMetadataResourceLocation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataprocMetastoreServer).AlterMetadataResourceLocation(ctx, req.(*AlterMetadataResourceLocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataprocMetastore_ServiceDesc is the grpc.ServiceDesc for DataprocMetastore service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataprocMetastore_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.metastore.v1beta.DataprocMetastore",
	HandlerType: (*DataprocMetastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _DataprocMetastore_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _DataprocMetastore_GetService_Handler,
		},
		{
			MethodName: "CreateService",
			Handler:    _DataprocMetastore_CreateService_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _DataprocMetastore_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _DataprocMetastore_DeleteService_Handler,
		},
		{
			MethodName: "ListMetadataImports",
			Handler:    _DataprocMetastore_ListMetadataImports_Handler,
		},
		{
			MethodName: "GetMetadataImport",
			Handler:    _DataprocMetastore_GetMetadataImport_Handler,
		},
		{
			MethodName: "CreateMetadataImport",
			Handler:    _DataprocMetastore_CreateMetadataImport_Handler,
		},
		{
			MethodName: "UpdateMetadataImport",
			Handler:    _DataprocMetastore_UpdateMetadataImport_Handler,
		},
		{
			MethodName: "ExportMetadata",
			Handler:    _DataprocMetastore_ExportMetadata_Handler,
		},
		{
			MethodName: "RestoreService",
			Handler:    _DataprocMetastore_RestoreService_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _DataprocMetastore_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _DataprocMetastore_GetBackup_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _DataprocMetastore_CreateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _DataprocMetastore_DeleteBackup_Handler,
		},
		{
			MethodName: "RemoveIamPolicy",
			Handler:    _DataprocMetastore_RemoveIamPolicy_Handler,
		},
		{
			MethodName: "QueryMetadata",
			Handler:    _DataprocMetastore_QueryMetadata_Handler,
		},
		{
			MethodName: "MoveTableToDatabase",
			Handler:    _DataprocMetastore_MoveTableToDatabase_Handler,
		},
		{
			MethodName: "AlterMetadataResourceLocation",
			Handler:    _DataprocMetastore_AlterMetadataResourceLocation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/metastore/v1beta/metastore.proto",
}
