// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/tool.proto

package dialogflowpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Tools_CreateTool_FullMethodName = "/google.cloud.dialogflow.v2.Tools/CreateTool"
	Tools_GetTool_FullMethodName    = "/google.cloud.dialogflow.v2.Tools/GetTool"
	Tools_ListTools_FullMethodName  = "/google.cloud.dialogflow.v2.Tools/ListTools"
	Tools_DeleteTool_FullMethodName = "/google.cloud.dialogflow.v2.Tools/DeleteTool"
	Tools_UpdateTool_FullMethodName = "/google.cloud.dialogflow.v2.Tools/UpdateTool"
)

// ToolsClient is the client API for Tools service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ToolsClient interface {
	// Creates a tool.
	CreateTool(ctx context.Context, in *CreateToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Retrieves a tool.
	GetTool(ctx context.Context, in *GetToolRequest, opts ...grpc.CallOption) (*Tool, error)
	// Lists tools.
	ListTools(ctx context.Context, in *ListToolsRequest, opts ...grpc.CallOption) (*ListToolsResponse, error)
	// Deletes a tool.
	DeleteTool(ctx context.Context, in *DeleteToolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a tool.
	UpdateTool(ctx context.Context, in *UpdateToolRequest, opts ...grpc.CallOption) (*Tool, error)
}

type toolsClient struct {
	cc grpc.ClientConnInterface
}

func NewToolsClient(cc grpc.ClientConnInterface) ToolsClient {
	return &toolsClient{cc}
}

func (c *toolsClient) CreateTool(ctx context.Context, in *CreateToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, Tools_CreateTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) GetTool(ctx context.Context, in *GetToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, Tools_GetTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) ListTools(ctx context.Context, in *ListToolsRequest, opts ...grpc.CallOption) (*ListToolsResponse, error) {
	out := new(ListToolsResponse)
	err := c.cc.Invoke(ctx, Tools_ListTools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) DeleteTool(ctx context.Context, in *DeleteToolRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Tools_DeleteTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *toolsClient) UpdateTool(ctx context.Context, in *UpdateToolRequest, opts ...grpc.CallOption) (*Tool, error) {
	out := new(Tool)
	err := c.cc.Invoke(ctx, Tools_UpdateTool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ToolsServer is the server API for Tools service.
// All implementations should embed UnimplementedToolsServer
// for forward compatibility
type ToolsServer interface {
	// Creates a tool.
	CreateTool(context.Context, *CreateToolRequest) (*Tool, error)
	// Retrieves a tool.
	GetTool(context.Context, *GetToolRequest) (*Tool, error)
	// Lists tools.
	ListTools(context.Context, *ListToolsRequest) (*ListToolsResponse, error)
	// Deletes a tool.
	DeleteTool(context.Context, *DeleteToolRequest) (*emptypb.Empty, error)
	// Updates a tool.
	UpdateTool(context.Context, *UpdateToolRequest) (*Tool, error)
}

// UnimplementedToolsServer should be embedded to have forward compatible implementations.
type UnimplementedToolsServer struct {
}

func (UnimplementedToolsServer) CreateTool(context.Context, *CreateToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTool not implemented")
}
func (UnimplementedToolsServer) GetTool(context.Context, *GetToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTool not implemented")
}
func (UnimplementedToolsServer) ListTools(context.Context, *ListToolsRequest) (*ListToolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTools not implemented")
}
func (UnimplementedToolsServer) DeleteTool(context.Context, *DeleteToolRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTool not implemented")
}
func (UnimplementedToolsServer) UpdateTool(context.Context, *UpdateToolRequest) (*Tool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTool not implemented")
}

// UnsafeToolsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ToolsServer will
// result in compilation errors.
type UnsafeToolsServer interface {
	mustEmbedUnimplementedToolsServer()
}

func RegisterToolsServer(s grpc.ServiceRegistrar, srv ToolsServer) {
	s.RegisterService(&Tools_ServiceDesc, srv)
}

func _Tools_CreateTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).CreateTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_CreateTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).CreateTool(ctx, req.(*CreateToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_GetTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).GetTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_GetTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).GetTool(ctx, req.(*GetToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_ListTools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListToolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).ListTools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_ListTools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).ListTools(ctx, req.(*ListToolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_DeleteTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).DeleteTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_DeleteTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).DeleteTool(ctx, req.(*DeleteToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tools_UpdateTool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateToolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ToolsServer).UpdateTool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tools_UpdateTool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ToolsServer).UpdateTool(ctx, req.(*UpdateToolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Tools_ServiceDesc is the grpc.ServiceDesc for Tools service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Tools_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.Tools",
	HandlerType: (*ToolsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTool",
			Handler:    _Tools_CreateTool_Handler,
		},
		{
			MethodName: "GetTool",
			Handler:    _Tools_GetTool_Handler,
		},
		{
			MethodName: "ListTools",
			Handler:    _Tools_ListTools_Handler,
		},
		{
			MethodName: "DeleteTool",
			Handler:    _Tools_DeleteTool_Handler,
		},
		{
			MethodName: "UpdateTool",
			Handler:    _Tools_UpdateTool_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/tool.proto",
}
