package etcd

import (
	"time"

	"github.com/coredns/coredns/request"
)

// Serial returns the serial number to use.
func (e *Etcd) Serial(state request.Request) uint32 {
	return uint32(time.Now().Unix()) // #nosec G115 -- Unix time to SOA serial, Year 2106 problem accepted
}

// MinTTL returns the minimal TTL.
func (e *Etcd) MinTTL(state request.Request) uint32 {
	return 30
}
