// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigMetricSlice(t *testing.T) {
	src := []*otlpmetrics.Metric{}
	dest := []*otlpmetrics.Metric{}
	// Test CopyTo empty
	dest = CopyOrigMetricSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.Metric{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestMetricSlice()
	dest = CopyOrigMetricSlice(dest, src)
	assert.Equal(t, GenerateOrigTestMetricSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigMetricSlice(dest, src)
	assert.Equal(t, GenerateOrigTestMetricSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigMetricSlice(dest, []*otlpmetrics.Metric{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigMetricSlice(dest, src)
	assert.Equal(t, GenerateOrigTestMetricSlice(), dest)
}
