/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;

public abstract class Settlement
extends GoodsLocation
implements Nameable,
Ownable {
    private static final Logger logger = Logger.getLogger(Settlement.class.getName());
    public static final int FOOD_PER_COLONIST = 200;
    private SettlementType type = null;
    protected Player owner;
    private String name;
    protected Tile tile;
    private final Set<Tile> ownedTiles = new HashSet<Tile>();
    private final FeatureContainer featureContainer = new FeatureContainer();
    private static final String NAME_TAG = "name";
    private static final String OWNER_TAG = "owner";
    private static final String SETTLEMENT_TYPE_TAG = "settlementType";
    private static final String TILE_TAG = "tile";

    protected Settlement(Game game, Player owner, String name, Tile tile) {
        super(game);
        this.owner = owner;
        this.name = name;
        this.tile = tile;
        this.changeType(owner.getNationType().getSettlementType(false));
    }

    public Settlement(Game game, String id) {
        super(game, id);
    }

    public final SettlementType getType() {
        return this.type;
    }

    public void setType(SettlementType newType) {
        this.type = newType;
    }

    public int getImmigration() {
        return 0;
    }

    public int getLiberty() {
        return 0;
    }

    public boolean isLandLocked() {
        return this.tile.isLandLocked();
    }

    private final void changeType(SettlementType newType) {
        if (this.type != null) {
            this.removeFeatures(this.type);
        }
        this.setType(newType);
        if (newType != null) {
            this.addFeatures(newType);
        }
    }

    public boolean isCapital() {
        return this.getType().isCapital();
    }

    public void setCapital(boolean capital) {
        if (this.isCapital() != capital) {
            this.changeType(this.owner.getNationType().getSettlementType(capital));
        }
    }

    public Set<Tile> getOwnedTiles() {
        return new HashSet<Tile>(this.ownedTiles);
    }

    protected void setOwnedTiles(Collection<Tile> ownedTiles) {
        this.ownedTiles.clear();
        this.ownedTiles.addAll(ownedTiles);
    }

    public void addTile(Tile tile) {
        this.ownedTiles.add(tile);
    }

    public void removeTile(Tile tile) {
        this.ownedTiles.remove(tile);
    }

    public int getRadius() {
        return this.getType().getClaimableRadius();
    }

    public int getLineOfSight() {
        return (int)this.apply(this.getType().getVisibleRadius(), this.getGame().getTurn(), "model.modifier.lineOfSightBonus");
    }

    public int getPlunder(Unit attacker, Random random) {
        RandomRange range = this.getPlunderRange(attacker);
        return range == null ? 0 : range.getAmount("Plunder " + this.getName(), random, false);
    }

    public Set<Tile> getVisibleTileSet() {
        Tile tile = this.getTile();
        return tile == null ? Collections.emptySet() : new HashSet<Tile>(tile.getSurroundingTiles(0, this.getLineOfSight()));
    }

    public void placeSettlement(boolean maximal) {
        List<Object> tiles;
        if (maximal) {
            tiles = this.owner.getClaimableTiles(this.tile, this.getRadius());
        } else {
            tiles = new ArrayList<Tile>();
            tiles.add(this.tile);
        }
        this.tile.setSettlement(this);
        for (Tile tile : tiles) {
            tile.changeOwnership(this.owner, this);
        }
        if (!this.tile.hasRoad()) {
            TileImprovement road = this.tile.addRoad();
            road.setTurnsToComplete(0);
            road.setVirtual(true);
            road.updateRoadConnections(true);
        }
    }

    public void exciseSettlement() {
        Tile settlementTile = this.getTile();
        for (Tile tile : this.getOwnedTiles()) {
            tile.changeOwnership(null, null);
        }
        settlementTile.setSettlement(null);
        settlementTile.changeOwnership(null, null);
        TileImprovement road = settlementTile.getRoad();
        if (road != null && road.getVirtual()) {
            settlementTile.removeRoad();
        }
    }

    public void changeOwner(Player newOwner) {
        Player oldOwner = this.owner;
        if (newOwner.isIndian() != oldOwner.isIndian()) {
            throw new RuntimeException("Can not transfer settlements between native and European players: " + oldOwner + " -> " + newOwner);
        }
        this.getGame().notifyOwnerChanged(this, oldOwner, newOwner);
        this.setOwner(newOwner);
        this.getGame().checkOwners(this, oldOwner);
        for (Tile t : this.getOwnedTiles()) {
            t.changeOwnership(newOwner, this);
        }
    }

    public boolean isConnectedPort() {
        return CollectionUtils.any(this.getTile().getSurroundingTiles(1, 1), t -> !t.isLand() && t.isHighSeasConnected());
    }

    public int getHighSeasCount() {
        Tile best = CollectionUtils.minimize(this.getTile().getSurroundingTiles(1, 1), Tile.isSeaTile, Tile.highSeasComparator);
        return best == null ? Integer.MAX_VALUE : best.getHighSeasCount();
    }

    protected int getConsumptionOf(GoodsType goodsType) {
        return Math.max(0, CollectionUtils.sum(this.getUnits(), u -> u.getType().getConsumptionOf(goodsType)));
    }

    protected int getConsumptionOf(List<GoodsType> goodsTypes) {
        return goodsTypes == null ? 0 : CollectionUtils.sum(goodsTypes, gt -> this.getConsumptionOf((GoodsType)gt));
    }

    public int getFoodConsumption() {
        return this.getConsumptionOf(this.getSpecification().getFoodGoodsTypeList());
    }

    protected boolean canProvideGoods(List<AbstractGoods> goods) {
        return CollectionUtils.all(goods, ag -> {
            int available = this.getGoodsCount(ag.getType());
            int breedingNumber = ag.getType().getBreedingNumber();
            if (breedingNumber != Integer.MAX_VALUE) {
                available -= breedingNumber;
            }
            return available >= ag.getAmount();
        });
    }

    public int getWarehouseCapacity() {
        return this.getGoodsCapacity();
    }

    public boolean canBombardEnemyShip() {
        return this.isLandLocked() ? false : this.hasAbility("model.ability.bombardShips");
    }

    public Role canImproveUnitMilitaryRole(Unit unit) {
        Specification spec = this.getSpecification();
        Role role = unit.getRole();
        List<Role> military = spec.getMilitaryRolesList();
        int index = military.indexOf(role);
        if (index >= 0) {
            military = military.subList(0, index);
        }
        return CollectionUtils.find(unit.getAvailableRoles(military), r -> this.canProvideGoods(unit.getGoodsDifference((Role)r, 1)));
    }

    public List<Unit> getAllUnitsList() {
        List<Unit> units = this.getUnitList();
        if (units.isEmpty()) {
            return this.getTile().getUnitList();
        }
        units.addAll(this.getTile().getUnitList());
        return units;
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return player == this.getOwner() ? this : this.getTile();
    }

    @Override
    public FeatureContainer getFeatureContainer() {
        return this.featureContainer;
    }

    @Override
    public void disposeResources() {
        if (this.owner != null) {
            this.owner.removeSettlement(this);
        }
        super.disposeResources();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        this.owner = player;
    }

    @Override
    public final Tile getTile() {
        return this.tile;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.name(this.getName());
    }

    @Override
    public final Settlement getSettlement() {
        return this;
    }

    @Override
    public final int getRank() {
        return Location.rankOf(this.getTile());
    }

    @Override
    public String getLocationImageKey() {
        return ImageLibrary.getSettlementKey(this);
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable instanceof Unit) {
            if (((Unit)locatable).getOwner() != this.getOwner()) {
                return UnitLocation.NoAddReason.OWNED_BY_ENEMY;
            }
        } else if (locatable instanceof Goods) {
            return UnitLocation.NoAddReason.NONE;
        }
        return super.getNoAddReason(locatable);
    }

    @Override
    public int priceGoods(List<AbstractGoods> goods) throws FreeColException {
        Predicate<AbstractGoods> pred = ag -> this.getGoodsCount(ag.getType()) < ag.getAmount();
        AbstractGoods missing = CollectionUtils.find(goods, pred);
        if (missing != null) {
            throw new FreeColException("Goods missing: " + missing);
        }
        return 0;
    }

    @Override
    public boolean equipForRole(Unit unit, Role role, int roleCount) {
        if (!unit.roleIsAvailable(role)) {
            return false;
        }
        List<AbstractGoods> req = unit.getGoodsDifference(role, roleCount);
        try {
            this.priceGoods(req);
        }
        catch (FreeColException fce) {
            return false;
        }
        for (AbstractGoods ag : req) {
            this.addGoods(ag.getType(), -ag.getAmount());
        }
        unit.changeRole(role, roleCount);
        return true;
    }

    public abstract Unit getDefendingUnit(Unit var1);

    public abstract double getDefenceRatio();

    public abstract boolean isBadlyDefended();

    public abstract RandomRange getPlunderRange(Unit var1);

    public abstract int getSonsOfLiberty();

    public abstract int getUpkeep();

    public abstract int getTotalProductionOf(GoodsType var1);

    public abstract boolean hasContacted(Player var1);

    public abstract StringTemplate getAlarmLevelLabel(Player var1);

    public abstract int calculateSettlementValue(int var1, Unit var2);

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        Player owner = this.getOwner();
        if (owner == null) {
            lb.add("\n  Settlement without owner: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Settlement o = this.copyInCast(other, Settlement.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.type = o.getType();
        this.owner = game.updateRef(o.getOwner());
        this.name = o.getName();
        this.tile = game.updateRef(o.getTile());
        this.setOwnedTiles(game.updateRef(o.getOwnedTiles()));
        this.featureContainer.copy(o.getFeatureContainer());
        if (this.owner != null) {
            this.owner.addSettlement(this);
        }
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(OWNER_TAG, this.owner);
        xw.writeAttribute(TILE_TAG, this.tile);
        xw.writeAttribute(SETTLEMENT_TYPE_TAG, this.getType());
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        if (xw.validFor(this.getOwner())) {
            super.writeChildren(xw);
            for (Ability ability : this.getSortedAbilities()) {
                if (!ability.isIndependent()) continue;
                ability.toXML(xw);
            }
            Turn turn = this.getGame().getTurn();
            for (Modifier modifier : this.getSortedModifiers()) {
                if (modifier.hasIncrement() && modifier.isOutOfDate(turn) || !modifier.isIndependent()) continue;
                modifier.toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Game game = this.getGame();
        this.name = xr.getAttribute(NAME_TAG, null);
        Player oldOwner = this.owner;
        this.owner = xr.findFreeColGameObject(game, OWNER_TAG, Player.class, null, true);
        this.tile = xr.findFreeColGameObject(game, TILE_TAG, Tile.class, null, true);
        String newType = xr.getAttribute(SETTLEMENT_TYPE_TAG, null);
        this.type = this.owner.getNationType().getSettlementType(newType);
        if (xr.shouldIntern()) {
            game.checkOwners(this, oldOwner);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.featureContainer.clear();
        super.readChildren(xr);
        this.addFeatures(this.type);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if ("ability".equals(tag)) {
            Ability ability = new Ability(xr, spec);
            if (ability.isIndependent()) {
                this.addAbility(ability);
            }
        } else if ("modifier".equals(tag)) {
            Modifier modifier = new Modifier(xr, spec);
            if (modifier.isIndependent()) {
                this.addModifier(modifier);
            }
        } else {
            super.readChild(xr);
        }
    }
}

