/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.params.IParams;

@Experimental
public class VSimParams
implements IParams {
    private Integer count;
    private Double epsilon;
    private Integer ef;
    private String filter;
    private Integer filterEf;
    private boolean truth;
    private boolean noThread;

    public VSimParams count(int num) {
        this.count = num;
        return this;
    }

    public VSimParams epsilon(double delta) {
        this.epsilon = delta;
        return this;
    }

    public VSimParams ef(int searchExplorationFactor) {
        this.ef = searchExplorationFactor;
        return this;
    }

    public VSimParams filter(String expression) {
        this.filter = expression;
        return this;
    }

    public VSimParams filterEf(int maxFilteringEffort) {
        this.filterEf = maxFilteringEffort;
        return this;
    }

    public VSimParams truth() {
        this.truth = true;
        return this;
    }

    public VSimParams noThread() {
        this.noThread = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.count != null) {
            args.add(Protocol.Keyword.COUNT).add(this.count);
        }
        if (this.epsilon != null) {
            args.add(Protocol.Keyword.EPSILON).add(this.epsilon);
        }
        if (this.ef != null) {
            args.add(Protocol.Keyword.EF).add(this.ef);
        }
        if (this.filter != null) {
            args.add(Protocol.Keyword.FILTER).add(this.filter);
        }
        if (this.filterEf != null) {
            args.add(Protocol.Keyword.FILTER_EF).add(this.filterEf);
        }
        if (this.truth) {
            args.add(Protocol.Keyword.TRUTH);
        }
        if (this.noThread) {
            args.add(Protocol.Keyword.NOTHREAD);
        }
    }
}

