/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.rls.LbPolicyConfiguration;
import io.grpc.rls.RlsLoadBalancer;
import io.grpc.rls.RlsProtoConverters;
import io.grpc.rls.RlsProtoData;
import java.util.List;
import java.util.Map;

@Internal
public final class RlsLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 6;
    }

    public String getPolicyName() {
        return "rls_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RlsLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingConfigPolicy) {
        try {
            RlsProtoData.RouteLookupConfig routeLookupConfig = (RlsProtoData.RouteLookupConfig)new RlsProtoConverters.RouteLookupConfigConverter().convert(JsonUtil.getObject(rawLoadBalancingConfigPolicy, (String)"routeLookupConfig"));
            Map routeLookupChannelServiceConfig = JsonUtil.getObject(rawLoadBalancingConfigPolicy, (String)"routeLookupChannelServiceConfig");
            LbPolicyConfiguration.ChildLoadBalancingPolicy lbPolicy = LbPolicyConfiguration.ChildLoadBalancingPolicy.create(JsonUtil.getString(rawLoadBalancingConfigPolicy, (String)"childPolicyConfigTargetFieldName"), JsonUtil.checkObjectList((List)((List)Preconditions.checkNotNull((Object)JsonUtil.getList(rawLoadBalancingConfigPolicy, (String)"childPolicy")))));
            return NameResolver.ConfigOrError.fromConfig((Object)new LbPolicyConfiguration(routeLookupConfig, routeLookupChannelServiceConfig, lbPolicy));
        }
        catch (Exception e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("can't parse config: " + e.getMessage()).withCause((Throwable)e));
        }
    }
}

