/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.projectmanagement.AndroidApp;
import com.google.firebase.projectmanagement.AndroidAppService;
import com.google.firebase.projectmanagement.FirebaseProjectManagementException;
import com.google.firebase.projectmanagement.FirebaseProjectManagementServiceImpl;
import com.google.firebase.projectmanagement.IosApp;
import com.google.firebase.projectmanagement.IosAppService;
import java.util.List;

public class FirebaseProjectManagement {
    private static final String SERVICE_ID = FirebaseProjectManagement.class.getName();
    private static final Object GET_INSTANCE_LOCK = new Object();
    private final String projectId;
    private AndroidAppService androidAppService;
    private IosAppService iosAppService;

    private FirebaseProjectManagement(String projectId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access the Firebase Project Management service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.projectId = projectId;
    }

    @VisibleForTesting
    void setAndroidAppService(AndroidAppService androidAppService) {
        this.androidAppService = androidAppService;
    }

    @VisibleForTesting
    void setIosAppService(IosAppService iosAppService) {
        this.iosAppService = iosAppService;
    }

    @NonNull
    public static FirebaseProjectManagement getInstance() {
        return FirebaseProjectManagement.getInstance(FirebaseApp.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static FirebaseProjectManagement getInstance(FirebaseApp app) {
        Object object = GET_INSTANCE_LOCK;
        synchronized (object) {
            FirebaseProjectManagementService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseProjectManagementService.class);
            if (service == null) {
                service = ImplFirebaseTrampolines.addService(app, new FirebaseProjectManagementService(app));
            }
            return (FirebaseProjectManagement)service.getInstance();
        }
    }

    @NonNull
    public AndroidApp getAndroidApp(@NonNull String appId) {
        return new AndroidApp(appId, this.androidAppService);
    }

    @NonNull
    public List<AndroidApp> listAndroidApps() throws FirebaseProjectManagementException {
        return this.androidAppService.listAndroidApps(this.projectId);
    }

    @NonNull
    public ApiFuture<List<AndroidApp>> listAndroidAppsAsync() {
        return this.androidAppService.listAndroidAppsAsync(this.projectId);
    }

    @NonNull
    public AndroidApp createAndroidApp(@NonNull String packageName) throws FirebaseProjectManagementException {
        return this.createAndroidApp(packageName, null);
    }

    @NonNull
    public AndroidApp createAndroidApp(@NonNull String packageName, @Nullable String displayName) throws FirebaseProjectManagementException {
        return this.androidAppService.createAndroidApp(this.projectId, packageName, displayName);
    }

    @NonNull
    public ApiFuture<AndroidApp> createAndroidAppAsync(@NonNull String packageName) {
        return this.createAndroidAppAsync(packageName, null);
    }

    @NonNull
    public ApiFuture<AndroidApp> createAndroidAppAsync(@NonNull String packageName, @Nullable String displayName) {
        return this.androidAppService.createAndroidAppAsync(this.projectId, packageName, displayName);
    }

    @NonNull
    public IosApp getIosApp(@NonNull String appId) {
        return new IosApp(appId, this.iosAppService);
    }

    @NonNull
    public List<IosApp> listIosApps() throws FirebaseProjectManagementException {
        return this.iosAppService.listIosApps(this.projectId);
    }

    @NonNull
    public ApiFuture<List<IosApp>> listIosAppsAsync() {
        return this.iosAppService.listIosAppsAsync(this.projectId);
    }

    @NonNull
    public IosApp createIosApp(@NonNull String bundleId) throws FirebaseProjectManagementException {
        return this.createIosApp(bundleId, null);
    }

    @NonNull
    public IosApp createIosApp(@NonNull String bundleId, @Nullable String displayName) throws FirebaseProjectManagementException {
        return this.iosAppService.createIosApp(this.projectId, bundleId, displayName);
    }

    @NonNull
    public ApiFuture<IosApp> createIosAppAsync(@NonNull String bundleId) {
        return this.createIosAppAsync(bundleId, null);
    }

    @NonNull
    public ApiFuture<IosApp> createIosAppAsync(@NonNull String bundleId, @Nullable String displayName) {
        return this.iosAppService.createIosAppAsync(this.projectId, bundleId, displayName);
    }

    private static class FirebaseProjectManagementService
    extends FirebaseService<FirebaseProjectManagement> {
        private final FirebaseProjectManagementServiceImpl serviceImpl;

        private FirebaseProjectManagementService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseProjectManagement(ImplFirebaseTrampolines.getProjectId(app)));
            this.serviceImpl = new FirebaseProjectManagementServiceImpl(app);
            FirebaseProjectManagement serviceInstance = (FirebaseProjectManagement)this.getInstance();
            serviceInstance.setAndroidAppService(this.serviceImpl);
            serviceInstance.setIosAppService(this.serviceImpl);
        }
    }
}

