/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.dpop.verifiers;

import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPIssuer;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofContext;
import com.nimbusds.oauth2.sdk.dpop.verifiers.DPoPProofUse;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.util.CollectionUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.singleuse.AlreadyUsedException;
import com.nimbusds.oauth2.sdk.util.singleuse.SingleUseChecker;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.net.URI;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class DPoPProofClaimsSetVerifier
extends DefaultJWTClaimsVerifier<DPoPProofContext> {
    private final long maxClockSkewSeconds;
    private final long maxAgeSeconds;
    private final Set<Nonce> acceptedNonces;
    private final SingleUseChecker<DPoPProofUse> singleUseChecker;
    @Deprecated
    private final SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> deprecatedSingleUseChecker;

    public DPoPProofClaimsSetVerifier(URI acceptedURI, String acceptedMethod, Set<Nonce> acceptedNonces, long maxClockSkewSeconds, long maxAgeSeconds, boolean requireATH, SingleUseChecker<DPoPProofUse> singleUseChecker) {
        super(null, DPoPProofClaimsSetVerifier.composeExactMatchClaims(acceptedURI, acceptedMethod), DPoPProofClaimsSetVerifier.composedRequiredClaimsWithAnyValue(CollectionUtils.isNotEmpty(acceptedNonces), requireATH), DPoPProofClaimsSetVerifier.composeProhibitedClaims(CollectionUtils.isEmpty(acceptedNonces)));
        if (maxAgeSeconds < maxClockSkewSeconds) {
            throw new IllegalArgumentException("The iat max age must be greater than or equal to the iat max clock skew");
        }
        this.maxClockSkewSeconds = maxClockSkewSeconds;
        this.maxAgeSeconds = maxAgeSeconds;
        this.acceptedNonces = CollectionUtils.isNotEmpty(acceptedNonces) ? Collections.unmodifiableSet(acceptedNonces) : null;
        this.singleUseChecker = singleUseChecker;
        this.deprecatedSingleUseChecker = null;
    }

    @Deprecated
    public DPoPProofClaimsSetVerifier(URI acceptedURI, String acceptedMethod, Set<Nonce> acceptedNonces, long maxClockSkewSeconds, boolean requireATH, SingleUseChecker<Map.Entry<DPoPIssuer, JWTID>> singleUseChecker) {
        super(null, DPoPProofClaimsSetVerifier.composeExactMatchClaims(acceptedURI, acceptedMethod), DPoPProofClaimsSetVerifier.composedRequiredClaimsWithAnyValue(CollectionUtils.isNotEmpty(acceptedNonces), requireATH), DPoPProofClaimsSetVerifier.composeProhibitedClaims(CollectionUtils.isEmpty(acceptedNonces)));
        this.maxClockSkewSeconds = maxClockSkewSeconds;
        this.maxAgeSeconds = 0L;
        this.acceptedNonces = CollectionUtils.isNotEmpty(acceptedNonces) ? Collections.unmodifiableSet(acceptedNonces) : null;
        this.singleUseChecker = null;
        this.deprecatedSingleUseChecker = singleUseChecker;
    }

    private static JWTClaimsSet composeExactMatchClaims(URI uri, String method) {
        JWTClaimsSet.Builder b = new JWTClaimsSet.Builder().claim("htm", (Object)method).claim("htu", (Object)URIUtils.getBaseURI(uri).toString());
        return b.build();
    }

    private static Set<String> composedRequiredClaimsWithAnyValue(boolean requireNonce, boolean requireATH) {
        HashSet<String> claimNames = new HashSet<String>(Arrays.asList("jti", "iat"));
        if (requireNonce) {
            claimNames.add("nonce");
        }
        if (requireATH) {
            claimNames.add("ath");
        }
        return Collections.unmodifiableSet(claimNames);
    }

    private static Set<String> composeProhibitedClaims(boolean prohibitNonce) {
        return prohibitNonce ? Collections.singleton("nonce") : null;
    }

    public void verify(JWTClaimsSet claimsSet, DPoPProofContext context) throws BadJWTException {
        context.setJWTClaimsSet(claimsSet);
        super.verify(claimsSet, (SecurityContext)context);
        Date iat = claimsSet.getIssueTime();
        Date now = new Date();
        long maxPastSecs = Math.max(this.maxClockSkewSeconds, this.maxAgeSeconds);
        Date maxPast = new Date(now.getTime() - maxPastSecs * 1000L);
        if (iat.before(maxPast)) {
            throw new BadJWTException("DPoP proof iat too old (>" + maxPastSecs + "s)");
        }
        Date maxFuture = new Date(now.getTime() + this.maxClockSkewSeconds * 1000L);
        if (iat.after(maxFuture)) {
            throw new BadJWTException("DPoP proof iat too far in future (>" + this.maxClockSkewSeconds + "s)");
        }
        if (CollectionUtils.isNotEmpty(this.acceptedNonces)) {
            Nonce nonce;
            try {
                nonce = new Nonce(claimsSet.getStringClaim("nonce"));
            }
            catch (IllegalArgumentException | ParseException e) {
                throw new BadJWTException("Illegal JWT nonce claim");
            }
            if (!this.acceptedNonces.contains(nonce)) {
                throw new BadJWTException("JWT nonce claim value rejected");
            }
        }
        if (this.singleUseChecker != null || this.deprecatedSingleUseChecker != null) {
            JWTID jti = new JWTID(claimsSet.getJWTID());
            try {
                if (this.singleUseChecker != null) {
                    this.singleUseChecker.markAsUsed(new DPoPProofUse(context.getIssuer(), jti, this.maxAgeSeconds));
                } else {
                    this.deprecatedSingleUseChecker.markAsUsed(new AbstractMap.SimpleImmutableEntry<DPoPIssuer, JWTID>(context.getIssuer(), jti));
                }
            }
            catch (AlreadyUsedException e) {
                throw new BadJWTException("The jti was already used in the past " + this.maxAgeSeconds + " seconds");
            }
        }
        if (this.getRequiredClaims().contains("ath")) {
            Base64URL ath;
            try {
                String athValue = claimsSet.getStringClaim("ath");
                if (StringUtils.isBlank(athValue)) {
                    throw new BadJWTException("Missing JWT ath claim");
                }
                ath = new Base64URL(athValue);
            }
            catch (ParseException e) {
                throw new BadJWTException("Illegal JWT ath claim", (Throwable)e);
            }
            context.setAccessTokenHash(ath);
        }
    }
}

