/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.network.validator;

import com.ubnt.A;
import com.ubnt.C.A.o0OO;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.X;
import com.ubnt.service.network.configuration.B.OO0o;
import com.ubnt.service.network.configuration.Object;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.template.network.validator.NetworkOrchestrationError;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NetworkTemplateErrorValidator {
    private static final Logger LOGGER = jA.\u00f6\u00d20000;
    private static final int DHCP_SERVER_MAX_SIZE = 3;
    private static final int DHCP_RELAY_SERVERS_MAX_SIZE = 5;
    private static final int NTP_IP_LIST_MAX_SIZE = 2;
    private static final int WINS_IP_LIST_MAX_SIZE = 2;
    private static final int DNS_IP_LIST_MAX_SIZE = 4;
    private final com.ubnt.service.network.configuration.A networkConfigurationValidator;
    private final Object networkConfigService;

    public List<IssueDetailReportDto> checkTemplateForErrors(List<NetworkConf> list) {
        return list.stream().flatMap(networkConf -> this.void((NetworkConf)networkConf).stream()).toList();
    }

    private List<IssueDetailReportDto> void(NetworkConf networkConf) {
        o0OO o0OO2 = o0OO.\u00d300000();
        String string = networkConf.getSiteId();
        this.o00000(string, networkConf, (o0OO<IssueDetailReportDto>)o0OO2);
        this.Object(string, networkConf, (o0OO<IssueDetailReportDto>)o0OO2);
        this.\u00f400000(string, networkConf, (o0OO<IssueDetailReportDto>)o0OO2);
        this.\u00d200000(string, networkConf, (o0OO<IssueDetailReportDto>)o0OO2);
        this.\u00d400000(string, networkConf, (o0OO<IssueDetailReportDto>)o0OO2);
        this.\u00d500000(string, networkConf, (o0OO<IssueDetailReportDto>)o0OO2);
        try {
            NetworkConf networkConf2 = this.networkConfigService.\u00f6O0000(string, networkConf.getId()).orElse(null);
            this.networkConfigurationValidator.\u00d8oO000(string, networkConf2, networkConf, new X());
        }
        catch (OO0o oO0o2) {
            LOGGER.warn("Error occurred while validating network template for site {}: {}", (java.lang.Object)string, (java.lang.Object)oO0o2.getMessage());
            o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.fromNetworkValidationExceptionReason(oO0o2.\u00d800000())).issueDetail(oO0o2.getMessage()).build());
        }
        catch (Exception exception) {
            LOGGER.error("Unexpected error occurred while validating network template for site {}", (java.lang.Object)string, (java.lang.Object)exception);
            o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.INVALID_TEMPLATE).issueDetail(exception.getMessage()).build());
        }
        return o0OO2.o00000();
    }

    private void o00000(String string, NetworkConf networkConf, o0OO<IssueDetailReportDto> o0OO2) {
        List<String> list = networkConf.getDhcpdIpList();
        if (list.size() > 3) {
            o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_TOO_MANY_DHCP_SERVERS).issueDetail("Too many DHCP server IP addresses in site %s. Maximum allowed is %d".formatted(string, 3)).build());
        }
    }

    private void Object(String string, NetworkConf networkConf, o0OO<IssueDetailReportDto> o0OO2) {
        if (networkConf.isDhcpdNtpEnabled()) {
            List<String> list = networkConf.getNtpIpList();
            if (A.nullsuper(list)) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_DHCP_NTP_IP_LIST_MISSING).issueDetail("DHCP NTP is enabled but no ntp IP addresses are provided").build());
            } else if (list.size() > 2) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_TOO_MANY_NTP_SERVERS).issueDetail("Too many NTP server IP addresses in site %s. Maximum allowed is %d".formatted(string, 2)).build());
            }
        }
    }

    private void \u00f400000(String string, NetworkConf networkConf, o0OO<IssueDetailReportDto> o0OO2) {
        if (networkConf.isDhcpdWinsEnabled()) {
            List<String> list = networkConf.getDhcpdWinsIpList();
            if (A.nullsuper(list)) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_DHCP_WINS_IP_LIST_MISSING).issueDetail("DHCP Wins is enabled but no wins IP addresses are provided").build());
            } else if (list.size() > 2) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_TOO_MANY_WINS_SERVERS).issueDetail("Too many WINS server IP addresses in site %s. Maximum allowed is %d".formatted(string, 2)).build());
            }
        }
    }

    private void \u00d200000(String string, NetworkConf networkConf, o0OO<IssueDetailReportDto> o0OO2) {
        if (networkConf.isDhcpdDnsEnabled()) {
            List<String> list = networkConf.getDhcpdDnsPrefixedList();
            if (A.nullsuper(list)) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_DHCP_DNS_IP_LIST_MISSING).issueDetail("DHCP DNS is enabled but no dns IP addresses are provided").build());
            } else if (list.size() > 4) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_TOO_MANY_DNS_SERVERS).issueDetail("Too many DNS server IP addresses in site %s. Maximum allowed is %d".formatted(string, 4)).build());
            }
        }
    }

    private void \u00d400000(String string, NetworkConf networkConf, o0OO<IssueDetailReportDto> o0OO2) {
        if (networkConf.isDhcpRelayEnabled()) {
            List<String> list = networkConf.getDhcpRelayServers();
            if (A.nullsuper(list)) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_DHCP_RELAY_SERVERS_MISSING).issueDetail("DHCP relay is enabled but no relay server IP addresses are provided").build());
            } else if (list.size() > 5) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV4_TOO_MANY_DHCP_RELAY_SERVERS).issueDetail("Too many DHCP relay server IP addresses in site %s. Maximum allowed is %d".formatted(string, 3)).build());
            }
        }
    }

    private void \u00d500000(String string, NetworkConf networkConf, o0OO<IssueDetailReportDto> o0OO2) {
        if (!networkConf.isDhcpdV6DnsAuto()) {
            List<String> list = networkConf.getDhcpdV6DnsIpList();
            if (A.nullsuper(list)) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV6_DHCP_DNS_IP_LIST_MISSING).issueDetail("DHCPV6 dns auto is disabled but no dns server IP addresses are provided").build());
            } else if (list.size() > 4) {
                o0OO2.String((java.lang.Object)IssueDetailReportDto.builder().code(NetworkOrchestrationError.IPV6_TOO_MANY_DNS_SERVERS).issueDetail("Too many IPv6 DNS server IP addresses in site %s. Maximum allowed is %d".formatted(string, 4)).build());
            }
        }
    }

    @ConstructorProperties(value={"networkConfigurationValidator", "networkConfigService"})
    @Generated
    public NetworkTemplateErrorValidator(com.ubnt.service.network.configuration.A a2, Object object) {
        this.networkConfigurationValidator = a2;
        this.networkConfigService = object;
    }
}

