/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web.filters.urlrewrite;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

public class UrlRewriteServlet
extends HttpServlet {
    private static final long serialVersionUID = 2186203405866227539L;
    private UrlRewriteFilter urlRewriteFilter = new UrlRewriteFilter();

    public void init(ServletConfig servletConfig) throws ServletException {
        this.urlRewriteFilter.init(new ConfigWrapper(servletConfig));
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.urlRewriteFilter.isLoaded()) {
            throw new UnavailableException("not initialised");
        }
        FilterChainWrapper filterChainWrapper = new FilterChainWrapper();
        this.urlRewriteFilter.doFilter((ServletRequest)request, (ServletResponse)response, filterChainWrapper);
    }

    public void destroy() {
        this.urlRewriteFilter.destroy();
    }

    static class ConfigWrapper
    implements FilterConfig {
        private ServletConfig servletConfig;

        public ConfigWrapper(ServletConfig servletConfig) {
            this.servletConfig = servletConfig;
        }

        public String getFilterName() {
            return this.servletConfig.getServletName();
        }

        public ServletContext getServletContext() {
            return this.servletConfig.getServletContext();
        }

        public String getInitParameter(String string) {
            return this.servletConfig.getInitParameter(string);
        }

        public Enumeration getInitParameterNames() {
            return this.servletConfig.getInitParameterNames();
        }
    }

    static class FilterChainWrapper
    implements FilterChain {
        FilterChainWrapper() {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        }
    }
}

