/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

public final class ArraySpliterator<T>
implements Spliterator<T> {
    private final Array<T> _array;
    private final int _fence;
    private int _index;

    public ArraySpliterator(Array<T> array2, int origin, int fence) {
        this._array = Objects.requireNonNull(array2);
        this._index = origin;
        this._fence = fence;
    }

    public ArraySpliterator(Array<T> array2) {
        this(array2, 0, array2.length());
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        int i;
        Objects.requireNonNull(action);
        Array<T> array2 = this._array;
        int hi = this._fence;
        if (array2.length() >= hi && (i = this._index) >= 0 && i < (this._index = hi)) {
            do {
                action.accept(array2.get(i));
            } while (++i < hi);
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this._index >= 0 && this._index < this._fence) {
            action.accept(this._array.get(this._index++));
            return true;
        }
        return false;
    }

    @Override
    public Spliterator<T> trySplit() {
        ArraySpliterator<T> arraySpliterator;
        int lo = this._index;
        int mid = lo + this._fence >>> 1;
        if (lo >= mid) {
            arraySpliterator = null;
        } else {
            this._index = mid;
            ArraySpliterator<T> arraySpliterator2 = new ArraySpliterator<T>(this._array, lo, this._index);
            arraySpliterator = arraySpliterator2;
        }
        return arraySpliterator;
    }

    @Override
    public long estimateSize() {
        return this._fence - this._index;
    }

    @Override
    public int characteristics() {
        return 16704;
    }
}

