/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.rels.DecompileRecord;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.GeneralStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.collections.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.collections.SFormsFastMapDirect;
import org.jetbrains.java.decompiler.util.collections.VBStyleCollection;

public class DotExporter {
    private static final String DOTS_FOLDER = System.getProperty("DOT_EXPORT_DIR", null);
    private static final String DOTS_ERROR_FOLDER = System.getProperty("DOT_ERROR_EXPORT_DIR", null);
    public static final boolean DUMP_DOTS = DOTS_FOLDER != null && !DOTS_FOLDER.trim().isEmpty();
    public static final boolean DUMP_ERROR_DOTS = DOTS_ERROR_FOLDER != null && !DOTS_ERROR_FOLDER.trim().isEmpty();
    private static final boolean EXTENDED_MODE = false;
    private static final boolean STATEMENT_LR_MODE = false;
    private static final boolean SAME_RANK_MODE = false;

    private static String statToDot(Statement stat, String name) {
        try (ImportCollector.Lock lock = DecompilerContext.getImportCollector().lock();){
            String string = DotExporter.statToDot(stat, name, null);
            return string;
        }
    }

    private static String statToDot(Statement stat, String name, Map<Statement, String> extraProps) {
        StringBuffer buffer = new StringBuffer();
        HashSet<Integer> visitedNodes = new HashSet<Integer>();
        HashSet<Integer> exits = new HashSet<Integer>();
        HashSet<Integer> referenced = new HashSet<Integer>();
        buffer.append("digraph " + name + " {\r\n");
        ArrayList<Statement> stats = new ArrayList<Statement>();
        stats.add(stat);
        DotExporter.findAllStats(stats, stat);
        DummyExitStatement exit = null;
        if (stat instanceof RootStatement) {
            exit = ((RootStatement)stat).getDummyExit();
        }
        HashMap<StatEdge, String> extraData = new HashMap<StatEdge, String>();
        HashSet<StatEdge> extraDataSeen = new HashSet<StatEdge>();
        for (Statement st : stats) {
            if (!(st instanceof IfStatement)) continue;
            IfStatement ifs = (IfStatement)st;
            if (ifs.getIfEdge() != null) {
                extraData.put(ifs.getIfEdge(), "If Edge");
            }
            if (ifs.getElseEdge() == null) continue;
            extraData.put(ifs.getElseEdge(), "Else Edge");
        }
        for (Statement st : stats) {
            String destId;
            String destId2;
            String sourceId = st.id + (st.getSuccessorEdges(2).isEmpty() ? "" : "000000");
            boolean edges = false;
            for (StatEdge edge : st.getSuccessorEdges(Integer.MIN_VALUE)) {
                destId2 = edge.getDestination().id + (edge.getDestination().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                Object edgeType = DotExporter.getEdgeType(edge);
                String meta = DotExporter.getEdgeMeta(edge);
                for (Map.Entry entry : extraData.entrySet()) {
                    if (edge.getSource().id != ((StatEdge)entry.getKey()).getSource().id || edge.getDestination().id != ((StatEdge)entry.getKey()).getDestination().id) continue;
                    edgeType = edgeType == null ? (String)entry.getValue() : (String)edgeType + " (" + (String)entry.getValue() + ")";
                    extraDataSeen.add((StatEdge)entry.getKey());
                }
                if (edge.closure != null) {
                    edgeType = edgeType == null ? "Closure: " + edge.closure.id : (String)edgeType + " (Closure: " + edge.closure.id + ")";
                }
                buffer.append(sourceId + "->" + destId2 + (edgeType != null ? "[label=\"" + (String)edgeType + "\", " + (String)meta + "]" : "[" + (String)meta + "]") + ";\n");
                if (edge.getType() == 32 || edge.getType() == 4) {
                    exits.add(edge.getDestination().id);
                }
                referenced.add(edge.getDestination().id);
                edges = true;
            }
            for (StatEdge edge : st.getSuccessorEdges(2)) {
                destId2 = edge.getDestination().id + (edge.getDestination().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                buffer.append(sourceId + " -> " + destId2 + " [style=dotted];\r\n");
                referenced.add(edge.getDestination().id);
                edges = true;
            }
            boolean foundFirst = false;
            boolean isIf = st instanceof IfStatement;
            boolean foundIf = false;
            boolean foundElse = false;
            for (Statement s : st.getStats()) {
                String destId3 = s.id + (s.getSuccessorEdges(2).isEmpty() ? "" : "000000");
                String label = "";
                if (s == st.getFirst()) {
                    label = "First";
                    foundFirst = true;
                }
                if (st instanceof IfStatement) {
                    IfStatement ifs = (IfStatement)st;
                    if (s == ifs.getIfstat()) {
                        label = "If stat";
                        foundIf = true;
                    }
                    if (s == ifs.getElsestat()) {
                        label = "Else stat";
                        foundElse = true;
                    }
                }
                buffer.append(sourceId + " -> " + destId3 + " [arrowhead=vee,color=red" + (String)(!label.equals("") ? ",fontcolor=red,label=\"" + label + "\"" : "") + "];\r\n");
                referenced.add(s.id);
            }
            if (!foundFirst && st.getFirst() != null) {
                destId = st.getFirst().id + (st.getFirst().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                buffer.append(sourceId + "->" + destId + " [arrowhead=vee,color=red,fontcolor=red,label=\"Dangling First statement!\"];\r\n");
            }
            if (isIf) {
                if (!foundIf && ((IfStatement)st).getIfstat() != null) {
                    destId = ((IfStatement)st).getIfstat().id + (st.getFirst().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                    buffer.append(sourceId + "->" + destId + " [arrowhead=vee,color=red,fontcolor=red,label=\"Dangling If statement!\"];\r\n");
                }
                if (!foundElse && ((IfStatement)st).getElsestat() != null) {
                    destId = ((IfStatement)st).getElsestat().id + (((IfStatement)st).getElsestat().getSuccessorEdges(2).isEmpty() ? "" : "000000");
                    buffer.append(sourceId + "->" + destId + " [arrowhead=vee,color=red,fontcolor=red,label=\"Dangling Else statement!\"];\r\n");
                }
            }
            visitedNodes.add(st.id);
            String extra = extraProps == null || !extraProps.containsKey(st) ? "" : "," + extraProps.get(st);
            String node = sourceId + " [shape=box,label=\"" + st.id + " (" + DotExporter.getStatType(st) + ")\\n" + DotExporter.toJava(st) + "\"" + (st == stat ? ",color=red" : "") + extra + "];\n";
            buffer.append(node);
        }
        if (exit != null) {
            buffer.append(exit.id + " [color=green,label=\"" + exit.id + " (Canonical Return)\"];\n");
            referenced.remove(exit.id);
        }
        referenced.removeAll(visitedNodes);
        for (Integer integer : referenced) {
            buffer.append(integer + " [color=red,label=\"" + integer + " (Unknown statement!)\"];\r\n");
        }
        for (StatEdge labelEdge : extraData.keySet()) {
            if (extraDataSeen.contains(labelEdge)) continue;
            String src = labelEdge.getSource().id + (labelEdge.getSource().getSuccessorEdges(2).isEmpty() ? "" : "000000");
            String destId = labelEdge.getDestination().id + (labelEdge.getDestination().getSuccessorEdges(2).isEmpty() ? "" : "000000");
            String label = "Floating extra edge: (" + (String)extraData.get(labelEdge) + ")";
            buffer.append(src + " -> " + destId + " [arrowhead=vee,color=red,fontcolor=red,label=\"" + label + "\"];\r\n");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String statementHierarchy(Statement stat) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph G {\r\n");
        buffer.append("subgraph cluster_root {\r\n");
        buffer.append(stat.id + " [shape=box,label=\"" + stat.id + " (" + DotExporter.getStatType(stat) + ")\r\n" + DotExporter.toJava(stat) + "\"];\r\n");
        DotExporter.recursivelyGraphStatement(buffer, stat);
        buffer.append("}\r\n");
        buffer.append("}");
        return buffer.toString();
    }

    private static void recursivelyGraphStatement(StringBuffer buffer, Statement statement) {
        buffer.append("subgraph cluster_" + statement.id + " {\r\n");
        buffer.append("label=\"" + statement.id + " (" + DotExporter.getStatType(statement) + ")\r\n" + DotExporter.toJava(statement) + "\";\r\n");
        for (Statement stat : statement.getStats()) {
            buffer.append(stat.id + " [shape=box,label=\"" + stat.id + " (" + DotExporter.getStatType(stat) + ")\r\n" + DotExporter.toJava(stat) + "\"];\r\n");
            DotExporter.recursivelyGraphStatement(buffer, stat);
        }
        buffer.append("}\r\n");
    }

    private static String toJava(Statement statement) {
        try {
            Object java = statement.toJava().convertToStringAndAllowDataDiscard().replace("\"", "\\\"").replace("\r", "").replace("\n", "\\l");
            if (statement instanceof BasicBlockStatement && (statement.getExprents() == null || statement.getExprents().isEmpty())) {
                java = "<" + (statement.getExprents() == null ? "null" : "empty") + " basic block>\\n" + (String)java;
            }
            return java;
        }
        catch (Exception e) {
            return "Could not get content";
        }
    }

    private static String getEdgeType(StatEdge edge) {
        switch (edge.getType()) {
            case 1: {
                return null;
            }
            case 2: {
                return "Exception";
            }
            case 4: {
                return "Break";
            }
            case 8: {
                return "Continue";
            }
            case 32: {
                return "Finally Exit";
            }
        }
        return "Unknown Edge (composite?)";
    }

    private static String getEdgeMeta(StatEdge edge) {
        switch (edge.getType()) {
            case 1: {
                return "weight=1, color=black";
            }
            case 2: {
                return "weight=1, color=orange, style=dashed";
            }
            case 4: {
                return "weight=0.4, color=blue";
            }
            case 8: {
                return "weight=0.2, color=green";
            }
            case 32: {
                return "weight=1, color=orange, style=dotted";
            }
        }
        return "weight=1, color=purple";
    }

    private static String getStatType(Statement st) {
        switch (st.type) {
            case GENERAL: {
                return ((GeneralStatement)st).isPlaceholder() ? "General (Placeholder)" : "General";
            }
            case IF: {
                return "If";
            }
            case DO: {
                return "Do";
            }
            case SWITCH: {
                return "Switch";
            }
            case TRY_CATCH: {
                return "Try Catch";
            }
            case BASIC_BLOCK: {
                return "Basic Block #" + ((BasicBlockStatement)st).getBlock().getId();
            }
            case SYNCHRONIZED: {
                return "Synchronized";
            }
            case CATCH_ALL: {
                return "Catch All";
            }
            case ROOT: {
                return "Root";
            }
            case DUMMY_EXIT: {
                return "Dummy Exit";
            }
            case SEQUENCE: {
                return "Sequence";
            }
        }
        return "Unknown";
    }

    private static void findAllStats(List<Statement> list, Statement root) {
        for (Statement stat : root.getStats()) {
            if (!list.contains(stat)) {
                list.add(stat);
            }
            if (stat instanceof IfStatement) {
                IfStatement ifs = (IfStatement)stat;
                if (ifs.getIfstat() != null && !list.contains(ifs.getIfstat())) {
                    list.add(ifs.getIfstat());
                }
                if (ifs.getElsestat() != null && !list.contains(ifs.getElsestat())) {
                    list.add(ifs.getElsestat());
                }
            }
            DotExporter.findAllStats(list, stat);
        }
    }

    private static String cfgToDot(String name, ControlFlowGraph graph, boolean showMultipleEdges) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph " + name + " {\r\n");
        VBStyleCollection<BasicBlock, Integer> blocks = graph.getBlocks();
        for (BasicBlock block : blocks) {
            buffer.append(block.getId() + " [shape=box,label=\"Block " + block.getId() + "\n" + String.valueOf(block.getSeq()) + "\"];\r\n");
            List<BasicBlock> suc = block.getSuccs();
            List<BasicBlock> preds = block.getPreds();
            for (BasicBlock basicBlock : suc) {
                buffer.append(block.getId() + " -> " + basicBlock.getId() + ";\r\n");
            }
            suc = block.getSuccExceptions();
            preds = block.getPredExceptions();
            for (int j = 0; j < suc.size(); ++j) {
                buffer.append(block.getId() + " -> " + suc.get(j).getId() + " [style=dotted];\r\n");
            }
        }
        for (int i = 0; i < graph.getExceptions().size(); ++i) {
            ExceptionRangeCFG ex = graph.getExceptions().get(i);
            buffer.append("subgraph cluster_ex_" + i + " {\r\n\tlabel=\"Exception range for Block " + ex.getHandler().getId() + " \";\r\n");
            for (BasicBlock bb : ex.getProtectedRange()) {
                buffer.append("\t" + bb.getId() + ";\r\n");
            }
            buffer.append("\t}\r\n");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static String decompileRecordToDot(DecompileRecord decompileRecord) {
        int i;
        StringBuilder builder = new StringBuilder();
        List<String> names = decompileRecord.getNames();
        int size = names.size();
        builder.append("digraph decompileRecord {\n");
        for (i = 0; i < size; ++i) {
            builder.append("\t").append(i).append(" [label=\"").append(names.get(i)).append("\"];\n");
        }
        builder.append("\n");
        for (i = 0; i < size - 1; ++i) {
            builder.append("\t").append(i).append(" -> ").append(i + 1).append(";\n");
        }
        builder.append("}");
        return builder.toString();
    }

    private static String varsToDot(VarVersionsGraph graph, Map<VarVersionPair, VarVersionPair> varAssignmentMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph G {\r\n");
        for (VarVersionNode varVersionNode : graph.nodes) {
            DotExporter.appendNode(builder, varVersionNode);
            if (varVersionNode.state == null) {
                builder.append(" [shape=box, style=dashed, ");
            } else {
                switch (varVersionNode.state) {
                    case PHI: {
                        builder.append(" [shape=oval,");
                        break;
                    }
                    case READ: {
                        builder.append(" [shape=box, ");
                        break;
                    }
                    case WRITE: {
                        builder.append(" [shape=box, style=filled, fillcolor=palegreen1, ");
                        break;
                    }
                    case PHANTOM: {
                        builder.append(" [shape=box; style=dotted, ");
                        break;
                    }
                    case DEAD_READ: {
                        builder.append(" [shape=box, style=filled, fillcolor=grey59, ");
                        break;
                    }
                    case PARAM: {
                        builder.append(" [shape=box, style=filled, fillcolor=skyblue1, ");
                        break;
                    }
                    case CATCH: {
                        builder.append(" [shape=box, style=filled, fillcolor=gold, ");
                    }
                }
            }
            builder.append("label=\"").append(varVersionNode.var).append("_").append(varVersionNode.version).append("\"];\r\n");
            for (VarVersionNode dest : varVersionNode.successors) {
                DotExporter.appendNode(builder, varVersionNode);
                builder.append("->");
                DotExporter.appendNode(builder, dest);
                builder.append(";\r\n");
            }
            if (varVersionNode.phantomNode == null) continue;
            DotExporter.appendNode(builder, varVersionNode);
            builder.append("->");
            DotExporter.appendNode(builder, varVersionNode.phantomNode);
            builder.append(" [style=dotted];\r\n");
        }
        if (varAssignmentMap != null) {
            for (Map.Entry entry : varAssignmentMap.entrySet()) {
                VarVersionPair to = (VarVersionPair)entry.getKey();
                VarVersionPair from = (VarVersionPair)entry.getValue();
                DotExporter.appendNode(builder, from);
                builder.append("->");
                DotExporter.appendNode(builder, to);
                builder.append(" [color=green];\r\n");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    private static void appendNode(StringBuilder builder, VarVersionNode node) {
        DotExporter.appendNode(builder, node.asPair());
    }

    private static void appendNode(StringBuilder builder, VarVersionPair pair) {
        if (pair.var >= 0) {
            builder.append("var").append(pair.var).append("_").append(pair.version);
        } else {
            builder.append("varM").append(-pair.var).append("_").append(pair.version);
        }
    }

    private static String domEngineToDot(DominatorEngine doms) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph G {\r\n");
        HashSet<Integer> nodes = new HashSet<Integer>();
        for (Integer key : doms.getOrderedIDoms().getLstKeys()) {
            nodes.add(key);
            nodes.add(doms.getOrderedIDoms().getWithKey(key));
            builder.append("x" + String.valueOf(doms.getOrderedIDoms().getWithKey(key)) + " -> x" + key + ";\n");
        }
        for (Integer nd : nodes) {
            builder.append("x" + nd + "[label=\"" + nd + "\"];\n");
        }
        builder.append("}");
        return builder.toString();
    }

    private static String digraphToDot(DirectGraph graph, Map<String, SFormsFastMapDirect> vars) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("digraph G {\r\n");
        VBStyleCollection<DirectNode, String> blocks = graph.nodes;
        for (DirectNode block : blocks) {
            SFormsFastMapDirect map;
            List<Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>>> lst;
            StringBuilder label = new StringBuilder(block.id + " in statement " + block.statement.id + " " + DotExporter.getStatType(block.statement));
            label.append("\\n");
            label.append(block.block != null ? DotExporter.toJava(block.block) : "null block");
            if (block.block == null) {
                TextBuffer buf = ExprProcessor.listToJava(block.exprents, 0);
                label.append("\\n");
                label.append(buf.convertToStringAndAllowDataDiscard());
            }
            if (vars != null && vars.containsKey(block.id) && (lst = (map = vars.get(block.id)).entryList()) != null) {
                for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> entry : lst) {
                    label.append("\\n").append(entry.getKey());
                    Set<Integer> set = entry.getValue().toPlainSet();
                    label.append("=").append(set);
                }
            }
            buffer.append("x" + block.id + " [shape=box,label=\"" + String.valueOf(label) + "\"];\r\n");
            for (DirectEdgeType type : DirectEdgeType.TYPES) {
                for (DirectEdge dest : block.getSuccessors(type)) {
                    buffer.append("x" + block.id + " -> x" + dest.getDestination().id + (type == DirectEdgeType.EXCEPTION ? "[style=dotted]" : "") + ";\r\n");
                }
            }
            if (block.tryFinally == null) continue;
            buffer.append("x" + block.id + " -> x" + block.tryFinally.id + "[color=blue];\r\n");
        }
        buffer.append("}");
        return buffer.toString();
    }

    private static File getFile(String folder, StructMethod mt, String suffix) {
        return DotExporter.getFile(folder, mt, "", suffix);
    }

    private static File getFile(String folder, StructMethod mt, String subdirectory, String suffix) {
        File root;
        if (!((String)folder).endsWith("/") && !((String)folder).endsWith("\\")) {
            folder = (String)folder + "/";
        }
        if (!(root = new File((String)folder + mt.getClassQualifiedName() + (String)(subdirectory.isEmpty() ? "" : "/" + subdirectory))).isDirectory()) {
            root.mkdirs();
        }
        return new File(root, mt.getName().replace('<', '.').replace('>', '_') + mt.getDescriptor().replace('/', '.') + "_" + suffix + ".dot");
    }

    private static File getFile(String folder, String name) {
        File root;
        if (!((String)folder).endsWith("/") && !((String)folder).endsWith("\\")) {
            folder = (String)folder + "/";
        }
        if (!(root = new File((String)folder)).isDirectory()) {
            root.mkdirs();
        }
        return new File(root, name + ".dot");
    }

    public static void toDotFile(DirectGraph dgraph, StructMethod mt, String suffix) {
        DotExporter.toDotFile(dgraph, mt, suffix, null);
    }

    public static void toDotFile(DirectGraph dgraph, StructMethod mt, String suffix, Map<String, SFormsFastMapDirect> vars) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, mt, suffix)));
            try (ImportCollector.Lock lock = DecompilerContext.getImportCollector().lock();){
                out.write(DotExporter.digraphToDot(dgraph, vars).getBytes());
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void errorToDotFile(DirectGraph dgraph, StructMethod mt, String suffix) {
        DotExporter.errorToDotFile(dgraph, mt, suffix, null);
    }

    public static void errorToDotFile(DirectGraph dgraph, StructMethod mt, String suffix, Map<String, SFormsFastMapDirect> vars) {
        if (!DUMP_ERROR_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_ERROR_FOLDER, mt, suffix)));
            try (ImportCollector.Lock lock = DecompilerContext.getImportCollector().lock();){
                out.write(DotExporter.digraphToDot(dgraph, vars).getBytes());
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(Statement stat, StructMethod mt, String suffix) {
        DotExporter.toDotFile(stat, mt, "", suffix);
    }

    public static void toDotFile(Statement stat, StructMethod mt, String subdirectory, String suffix) {
        DotExporter.toDotFile(stat, mt, subdirectory, suffix, null);
    }

    public static void toDotFile(Statement stat, StructMethod mt, String subdirectory, String suffix, Map<Statement, String> extraProps) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, mt, subdirectory, suffix)));
            try (ImportCollector.Lock lock = DecompilerContext.getImportCollector().lock();){
                out.write(DotExporter.statToDot(stat, suffix, extraProps).getBytes());
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void statementHierarchyToDot(Statement stat, StructMethod mt, String suffix) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, mt, suffix)));
            out.write(DotExporter.statementHierarchy(stat).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(Statement stat, String name) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, name)));
            out.write(DotExporter.statToDot(stat, name).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void errorToDotFile(Statement stat, StructMethod mt, String suffix) {
        if (!DUMP_ERROR_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_ERROR_FOLDER, mt, suffix)));
            out.write(DotExporter.statToDot(stat, suffix).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void errorToDotFile(Statement stat, String name) {
        if (!DUMP_ERROR_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_ERROR_FOLDER, name)));
            out.write(DotExporter.statToDot(stat, name).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(VarVersionsGraph graph, StructMethod mt, String suffix, Map<VarVersionPair, VarVersionPair> varAssignmentMap) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, mt, suffix)));
            out.write(DotExporter.varsToDot(graph, varAssignmentMap).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void errorToDotFile(VarVersionsGraph graph, StructMethod mt, String suffix, Map<VarVersionPair, VarVersionPair> varAssignmentMap) {
        if (!DUMP_ERROR_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_ERROR_FOLDER, mt, suffix)));
            out.write(DotExporter.varsToDot(graph, varAssignmentMap).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(DecompileRecord decompileRecord, StructMethod mt, String suffix, boolean error) {
        if (error ? !DUMP_ERROR_DOTS : !DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(error ? DOTS_ERROR_FOLDER : DOTS_FOLDER, mt, suffix)));
            out.write(DotExporter.decompileRecordToDot(decompileRecord).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(ControlFlowGraph graph, StructMethod mt, String suffix, boolean showMultipleEdges) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, mt, suffix)));
            out.write(DotExporter.cfgToDot(suffix, graph, showMultipleEdges).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void errorToDotFile(ControlFlowGraph graph, StructMethod mt, String suffix) {
        if (!DUMP_ERROR_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_ERROR_FOLDER, mt, suffix)));
            out.write(DotExporter.cfgToDot(suffix, graph, true).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toDotFile(DominatorEngine doms, StructMethod mt, String suffix) {
        if (!DUMP_DOTS) {
            return;
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(DotExporter.getFile(DOTS_FOLDER, mt, suffix)));
            out.write(DotExporter.domEngineToDot(doms).getBytes());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

